NOTE* This source was copied from the FF_CP2614 repo, specifically this commit:
https://stash.silabs.com/projects/MCU8_FW/repos/ff_cp2614/commits/ca815a224683d0a204c9f5d39c36e383a81375a1

This software was written by Joe Kroesche and integrated in to the AN721 RCP
App by Preston Fick

README for genconfig java app
=============================
This application is used to convert an XML configuration file into a C byte
array used as the configuration structure for a CP2614 device.  The
application consists of several java classes.

* CPConfigurator - the main application class.  It reads the XML file and
  uses the other classes to generate the C file output
* Field - encapsulates an XML field element.  This is the lowest level node
  type in the configuration file.  A Field specifies the type and value of
  the data that ends up in the byte array
* VarArray - encapsulates a vararray XML element.  This is a kind of container
  that expands into a fixed portion that is a length and offset, and the
  actual contents which are a variable-length portion.  The VarArray contains
  other types of elements such as Descriptor, Parameter, Field.
* Descriptor - encapsulates a XML descriptor element.  This represents a USB
  descriptor.  The Descriptor can be of type "device" or "configuration".
  A configuration descriptor can contain other descriptors, and the total
  length will be calculated.  A descriptor can contain other descriptors or
  fields.
* Parameter - encapsulates an XML parameter element.  This represents an iAP2
  message parameter.  A parameter can contain one or more fields.
* ParameterGroup - encapsulates an XML parameter group.  This represent an
  iAP2 parameter group.  A parameter group contains parameters.

I provide javadoc comments in these classes and you can run javadoc on them
to generate some not-terrible html doc pages.  (See Building topic below).

(Note: see Dependencies below for XML handling class)

The CPConfigurator is pretty much purpose built for the CP2614.  However,
except for the CPConfigurator class, the other classes are general in nature
and there is nothing that ties them to CP2614 as opposed to other fixed
function devices.  I believe that the other classes could be used from within
some other kind of generic configurator app.

At this time, the classes are used to take an input XML element node, and
then to produce C byte array output.  They need to be modified yet to also
produce binary output.  I intend to add this.  Another feature is to use these
classes to also generate XML.  In other words to facilitate translation in
the other direction - to create the XML configuration file instead of reading
it.  The Field class already partially implements this.  It provides a
constructor and methods for generating XML from input parameters.  The other
classes could be modified in a similar way.

The Descriptor and Field class could also be used apart from the rest of
these classes in order to just generate USB descriptors from an XML
description.  This could be used for USB descriptor generation in general
and not tied to CP2614 or even fixed function devices.

With regard to the CP2614, the XML file structure must match the expected
device configuration structure.  This is found in the file config.h in
the project src directory.  There is an example XML file showing what
the XML configuration file should look like along with demonstrating the
use of the various elements and attributes.  The file is included with these
source files and is named config_test.xml.  At the time of this writing this
example configuration file matches the CP2614 config.h, but this is certain
to change in the future.

Dependencies
============
These classes use the JDOM2 XML package.  This is org.jdom2.  You can find
it here: http://www.jdom.org/

The jar file must be on your classpath somewhere.  For Windows I put mine
in %SystemRoot%/Sun/Java/lib/ext, as described here:
http://docs.oracle.com/javase/tutorial/ext/basics/install.html
But you can put it anywhere else and just add it to CLASSPATH.

Building Etc
============
I provide a Makefile with several targets to build the CPConfigurator app
and to generate javadoc documentation.  Assuming you have a normal make
and development environment, you should be able to do the following:

* make compile - compile all the classes into the CPConfigurator app
* make doc - build the javadoc documentation
* make runtest - run the configurator using the test XML file
* make clean - clean the build products
* make cleandoc - clean the generated documentation

