/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.ui;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.IDeviceListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DevicesComposite
extends Composite
implements IDeviceListener {
    private final Combo cmbDevices;
    private final Button btnRefresh;
    private final ComboViewer viewer;

    public DevicesComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().equalWidth(false);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)this);
        this.cmbDevices = new Combo((Composite)this, 12);
        GridDataFactory.swtDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.cmbDevices);
        this.btnRefresh = new Button((Composite)this, 8);
        this.btnRefresh.setText("&Refresh");
        GridDataFactory.swtDefaults().applyTo((Control)this.btnRefresh);
        this.viewer = new ComboViewer(this.cmbDevices);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)new Device[0]);
        DeviceDetector.getDefault().addListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DeviceDetector.getDefault().removeListener(DevicesComposite.this);
            }
        });
        DeviceDetector.getDefault().start();
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceDetector.getDefault().start();
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    @Override
    public void devicesChanged() {
        final Device[] input = DeviceDetector.getDefault().getDevices();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DevicesComposite.this.viewer.getControl().isDisposed()) {
                    return;
                }
                DevicesComposite.this.viewer.setInput((Object)input);
                if (DevicesComposite.this.viewer.getSelection().isEmpty() && input.length > 0) {
                    DevicesComposite.this.viewer.setSelection((ISelection)new StructuredSelection((Object)input[0]));
                }
            }
        });
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }
}

