/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.ui;

import com.silabs.customizer.UIConstants;
import com.silabs.customizer.devices.CellEditorFactory;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyBaudConfig;
import com.silabs.customizer.devices.PropertyGroup;
import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.preferences.PreferenceConstants;
import com.silabs.customizer.ui.Accordeon;
import com.silabs.customizer.ui.TableColumnLayoutWithToggle;
import com.silabs.customizer.ui.TreeColumnLayoutWithToggle;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class ConfigurationComposite
extends Composite
implements ISelectionChangedListener {
    private Accordeon acConfig;
    private TableViewer vProperties;
    private Table tblProperties;
    private TreeViewer vBaudRates;
    private Tree tblBaudRates;
    private TreeViewer vPortConfigs;
    private Tree trPortConfigs;
    private Button btnProgram;
    private Image imgResetButton;
    private Color changedBg;
    private Color errorBg;
    private Color successBg;
    private com.silabs.customizer.devices.Device device;

    public ConfigurationComposite(Composite parent, int style) {
        super(parent, style);
        this.loadColors();
        this.loadImages();
        int numColumns = 2;
        GridLayoutFactory.swtDefaults().numColumns(numColumns).applyTo((Composite)this);
        String[] titles = new String[]{"Set IDs", "Baud Rate Alias", "Port Configuration"};
        this.acConfig = new Accordeon(this, 0, titles);
        this.createProperties(this.acConfig.getSection(0));
        this.createBaudRates(this.acConfig.getSection(1));
        this.createPortConfigs(this.acConfig.getSection(2));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.acConfig);
        this.btnProgram = new Button((Composite)this, 8);
        this.btnProgram.setText("&Program Device");
        int hHint = this.btnProgram.computeSize((int)-1, (int)-1).y * 2;
        GridDataFactory.fillDefaults().span(2, 1).hint(-1, hHint).grab(true, false).applyTo((Control)this.btnProgram);
        this.addListeners();
    }

    public Viewer[] getViewers() {
        return new Viewer[]{this.vProperties, this.vBaudRates, this.vPortConfigs};
    }

    public synchronized void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sSelection;
        Object first;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (first = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof com.silabs.customizer.devices.Device) {
            if (this.device == null || !this.device.equals(first)) {
                this.setInput(first);
            }
            this.updateVisible();
        }
    }

    private void updateVisible() {
        Control[] controls = this.acConfig.getChildren();
        controls[0].setVisible(false);
        controls[1].setVisible(false);
        controls[2].setVisible(false);
        controls[3].setVisible(false);
        controls[4].setVisible(false);
        controls[5].setVisible(false);
        if (this.device.isShowConfigureIds()) {
            controls[0].setVisible(true);
            controls[1].setVisible(true);
        }
        if (this.device.isShowConfigureBaudRate()) {
            controls[2].setVisible(true);
            controls[3].setVisible(true);
        }
        if (this.device.isShowConfigurePins()) {
            controls[4].setVisible(true);
            controls[5].setVisible(true);
        }
    }

    private void addListeners() {
        this.btnProgram.addSelectionListener((SelectionListener)new ProgramButtonListener());
        final ShowDefaultsListener listener = new ShowDefaultsListener();
        PreferenceConstants.getStore().addPropertyChangeListener((IPropertyChangeListener)listener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PreferenceConstants.getStore().removePropertyChangeListener(listener);
            }
        });
    }

    private void configureCellEditing(ColumnViewer viewer) {
        ColumnViewerEditorActivationStrategy activation = new ColumnViewerEditorActivationStrategy(viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            TableViewerEditor.create((TableViewer)tableViewer, (ColumnViewerEditorActivationStrategy)activation, (int)58);
        } else if (viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            TreeViewerEditor.create((TreeViewer)treeViewer, (ColumnViewerEditorActivationStrategy)activation, (int)58);
        } else {
            throw new IllegalArgumentException("Unsupported viewer: " + String.valueOf(viewer));
        }
    }

    private void createBaudRates(Composite parent) {
        this.vBaudRates = new TreeViewer(parent, this.getViewerStyle());
        this.tblBaudRates = this.vBaudRates.getTree();
        this.tblBaudRates.setHeaderVisible(true);
        TreeViewerColumn col0 = this.createTreeColumn(this.vBaudRates, "High Baud Rate", true);
        TreeViewerColumn col1 = this.createTreeColumn(this.vBaudRates, "Low Baud Rate", true);
        TreeViewerColumn col2 = this.createTreeColumn(this.vBaudRates, "Actual Baud Rate", true);
        TreeViewerColumn col3 = this.createTreeColumn(this.vBaudRates, "Desired Baud Rate", true);
        TreeViewerColumn col4 = this.createTreeColumn(this.vBaudRates, "", false);
        TreeColumnLayoutWithToggle layout = new TreeColumnLayoutWithToggle();
        layout.setColumnData((Widget)col0.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col3.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col4.getColumn(), (ColumnLayoutData)new ColumnPixelData(this.getButtonWidthHint()));
        parent.setLayout((Layout)layout);
        this.vBaudRates.setLabelProvider((IBaseLabelProvider)new BaudConfigLabelProvider((Control)this.tblBaudRates, 3));
        this.vBaudRates.setContentProvider((IContentProvider)new BaudRateContentProvider());
        this.configureCellEditing((ColumnViewer)this.vBaudRates);
        col3.setEditingSupport((EditingSupport)new PropertyEditingSupport((ColumnViewer)this.vBaudRates));
        new FocusOnEditableColumn((ColumnViewer)this.vBaudRates, 3);
        this.tblBaudRates.addMouseListener((MouseListener)new ResetListener((StructuredViewer)this.vBaudRates, 4));
        col4.setLabelProvider((CellLabelProvider)new ResetToolTip());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.vBaudRates, (int)2);
    }

    private void createProperties(Composite parent) {
        this.vProperties = new TableViewer(parent, this.getViewerStyle());
        this.tblProperties = this.vProperties.getTable();
        this.tblProperties.setHeaderVisible(true);
        TableViewerColumn col0 = this.createTableColumn(this.vProperties, "Property", true);
        TableViewerColumn col1 = this.createTableColumn(this.vProperties, "Default", true);
        TableViewerColumn col2 = this.createTableColumn(this.vProperties, "Value", true);
        TableViewerColumn col3 = this.createTableColumn(this.vProperties, "", false);
        TableColumnLayoutWithToggle layout = new TableColumnLayoutWithToggle();
        layout.setColumnData((Widget)col0.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col3.getColumn(), (ColumnLayoutData)new ColumnPixelData(this.getButtonWidthHint()));
        parent.setLayout((Layout)layout);
        GridData gdParent = (GridData)parent.getLayoutData();
        gdParent.heightHint = this.tblProperties.getItemHeight() * 7;
        this.vProperties.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider((Control)this.tblProperties, 2));
        this.vProperties.setContentProvider((IContentProvider)new ArrayContentProvider());
        col3.setLabelProvider((CellLabelProvider)new ResetToolTip());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.vProperties, (int)2);
        this.configureCellEditing((ColumnViewer)this.vProperties);
        col2.setEditingSupport((EditingSupport)new PropertyEditingSupport((ColumnViewer)this.vProperties));
        new FocusOnEditableColumn((ColumnViewer)this.vProperties, 2);
        this.tblProperties.addMouseListener((MouseListener)new ResetListener((StructuredViewer)this.vProperties, 3));
    }

    private void createPortConfigs(Composite parent) {
        this.vPortConfigs = new TreeViewer(parent, this.getViewerStyle());
        this.trPortConfigs = this.vPortConfigs.getTree();
        this.trPortConfigs.setHeaderVisible(true);
        TreeViewerColumn col0 = this.createTreeColumn(this.vPortConfigs, "Pin Property", true);
        TreeViewerColumn col1 = this.createTreeColumn(this.vPortConfigs, "Default", true);
        TreeViewerColumn col2 = this.createTreeColumn(this.vPortConfigs, "Value", true);
        TreeViewerColumn col3 = this.createTreeColumn(this.vPortConfigs, "", false);
        TreeColumnLayoutWithToggle layout = new TreeColumnLayoutWithToggle();
        layout.setColumnData((Widget)col0.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        layout.setColumnData((Widget)col3.getColumn(), (ColumnLayoutData)new ColumnPixelData(this.getButtonWidthHint()));
        parent.setLayout((Layout)layout);
        this.vPortConfigs.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider((Control)this.trPortConfigs, 2));
        this.vPortConfigs.setContentProvider((IContentProvider)new PortContentProvider());
        col3.setLabelProvider((CellLabelProvider)new ResetToolTip());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.vPortConfigs, (int)2);
        this.configureCellEditing((ColumnViewer)this.vPortConfigs);
        col2.setEditingSupport((EditingSupport)new PropertyEditingSupport((ColumnViewer)this.vPortConfigs));
        new FocusOnEditableColumn((ColumnViewer)this.vPortConfigs, 2);
        this.trPortConfigs.addMouseListener((MouseListener)new ResetListener((StructuredViewer)this.vPortConfigs, 3));
    }

    private TableViewerColumn createTableColumn(TableViewer parent, String title, boolean resizable) {
        return this.createTableColumn(parent, title, null, resizable);
    }

    private TableViewerColumn createTableColumn(TableViewer parent, String title, String tooltip, boolean resizable) {
        TableViewerColumn result = new TableViewerColumn(parent, 0);
        TableColumn column = result.getColumn();
        column.setText(title);
        column.setToolTipText(tooltip);
        column.setResizable(resizable);
        return result;
    }

    private TreeViewerColumn createTreeColumn(TreeViewer parent, String title, boolean resizable) {
        TreeViewerColumn result = new TreeViewerColumn(parent, 0);
        TreeColumn column = result.getColumn();
        column.setText(title);
        column.setResizable(resizable);
        return result;
    }

    private int getButtonWidthHint() {
        int result = this.imgResetButton.getBounds().width + 4;
        if (UIConstants.isWsCocoa()) {
            result += 10;
        }
        return result;
    }

    private int getViewerStyle() {
        int tableStyle = 516;
        if (UIConstants.isWsWindows()) {
            tableStyle |= 0x10000;
        }
        return tableStyle;
    }

    private void loadColors() {
        Display display = this.getDisplay();
        this.changedBg = new Color((Device)display, UIConstants.RGB_CHANGED_BG);
        this.errorBg = new Color((Device)display, UIConstants.RGB_ERROR_BG);
        this.successBg = new Color((Device)display, UIConstants.RGB_SUCCESS_BG);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ConfigurationComposite.this.changedBg.dispose();
                ConfigurationComposite.this.errorBg.dispose();
                ConfigurationComposite.this.successBg.dispose();
            }
        });
    }

    private void loadImages() {
        Bundle bundle = Platform.getBundle((String)"com.silabs.customizer");
        String path = "/icons/undo.gif";
        URL[] url = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(path));
        try {
            ImageDescriptor descr = ImageDescriptor.createFromURL((URL)FileLocator.resolve((URL)url[0]));
            this.imgResetButton = descr.createImage();
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ConfigurationComposite.this.imgResetButton != null) {
                        ConfigurationComposite.this.imgResetButton.dispose();
                    }
                }
            });
        }
        catch (IOException ioe) {
            MessageLog.error("Failed to load image:" + path, ioe);
        }
    }

    private void setInput(Object first) {
        MessageLog.debug("Selection changed:", first);
        this.device = (com.silabs.customizer.devices.Device)first;
        this.acConfig.getSection(0).setVisible(this.device.isShowConfigureIds());
        this.acConfig.getSection(1).setVisible(this.device.isShowConfigureBaudRate());
        this.acConfig.getSection(2).setVisible(this.device.isShowConfigurePins());
        this.btnProgram.setEnabled(!(this.device instanceof DeviceNone));
        this.vProperties.setInput((Object)this.device.getIds());
        this.vBaudRates.setInput((Object)this.device.getBaudRates());
        this.vPortConfigs.setInput((Object)this.device.getPortConfigs());
    }

    private final class BaudConfigLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private final Control control;
        private final int editableColumn;
        private Font boldRowFont;

        public BaudConfigLabelProvider(Control tableOrTree, int editableColumn) {
            this.control = tableOrTree;
            this.editableColumn = editableColumn;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            Color result = null;
            if (columnIndex == this.editableColumn) {
                Property property = (Property)element;
                if (!(property instanceof PropertyGroup)) {
                    if (property.isError()) {
                        result = ConfigurationComposite.this.errorBg;
                    } else if (property.isWritten()) {
                        result = ConfigurationComposite.this.successBg;
                    } else if (property.isChanged()) {
                        result = ConfigurationComposite.this.changedBg;
                    }
                }
            } else {
                result = Display.getCurrent().getSystemColor(22);
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PropertyBaudConfig property = (PropertyBaudConfig)element;
            switch (columnIndex) {
                case 0: {
                    return property.getHighValue();
                }
                case 1: {
                    return property.getLowValue();
                }
                case 2: {
                    return property.getActualValue();
                }
                case 3: {
                    return property.getValue();
                }
            }
            return "";
        }

        public Font getFont(Object element, int columnIndex) {
            if (element instanceof PropertyGroup && columnIndex == 0) {
                return this.getBoldFont();
            }
            return null;
        }

        private Font getBoldFont() {
            if (this.boldRowFont == null) {
                FontData[] fontDatas;
                FontData[] fontDataArray = fontDatas = this.control.getFont().getFontData();
                int n = fontDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    FontData fd = fontDataArray[n2];
                    fd.setStyle(1);
                    ++n2;
                }
                this.boldRowFont = new Font((Device)ConfigurationComposite.this.getDisplay(), fontDatas);
                this.control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        BaudConfigLabelProvider.this.boldRowFont.dispose();
                    }
                });
            }
            return this.boldRowFont;
        }
    }

    private static final class BaudRateContentProvider
    implements ITreeContentProvider {
        private BaudRateContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = (Property[])inputElement;
            if (result.length == 1 && result[0] instanceof PropertyGroup) {
                PropertyGroup root = (PropertyGroup)result[0];
                result = root.getChildren();
            }
            return result;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertyGroup) {
                return ((PropertyGroup)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PropertyGroup;
        }
    }

    private static final class ComboCellEditor
    extends ComboBoxCellEditor {
        private ComboCellEditor(Composite parent, String[] items, int style) {
            super(parent, items, style);
        }

        protected Control createControl(Composite parent) {
            Control result = super.createControl(parent);
            result.setBackground(parent.getBackground());
            return result;
        }
    }

    private static final class FocusOnEditableColumn
    extends MouseAdapter
    implements KeyListener {
        private final ColumnViewer viewer;
        private final int editableColumn;

        FocusOnEditableColumn(ColumnViewer viewer, int editableColumn) {
            this.viewer = viewer;
            this.editableColumn = editableColumn;
            if (viewer instanceof TableViewer) {
                Table table = ((TableViewer)viewer).getTable();
                table.addMouseListener((MouseListener)this);
                table.addKeyListener((KeyListener)this);
            } else if (viewer instanceof TreeViewer) {
                Tree tree = ((TreeViewer)viewer).getTree();
                tree.addMouseListener((MouseListener)this);
                tree.addKeyListener((KeyListener)this);
            } else {
                throw new IllegalArgumentException("Unsupported viewer: " + String.valueOf(viewer));
            }
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                this.editCell();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            Object element;
            TreeViewer treeViewer;
            if (this.viewer instanceof TreeViewer && (treeViewer = (TreeViewer)this.viewer).isExpandable(element = this.getSelectedElement())) {
                boolean isExpanded = treeViewer.getExpandedState(element);
                treeViewer.setExpandedState(element, !isExpanded);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 || e.keyCode == 32) {
                this.editCell();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        private void editCell() {
            Object element = this.getSelectedElement();
            if (element != null) {
                this.viewer.editElement(element, this.editableColumn);
            }
        }

        private Object getSelectedElement() {
            TreeViewer treeViewer;
            Tree tree;
            TreeItem[] items;
            Object result = null;
            if (this.viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)this.viewer;
                int index = tableViewer.getTable().getSelectionIndex();
                result = tableViewer.getElementAt(index);
            } else if (this.viewer instanceof TreeViewer && (items = (tree = (treeViewer = (TreeViewer)this.viewer).getTree()).getSelection()).length == 1) {
                result = items[0].getData();
            }
            return result;
        }
    }

    private static final class PortContentProvider
    implements ITreeContentProvider {
        private PortContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = (Property[])inputElement;
            if (result.length == 1 && result[0] instanceof PropertyGroup) {
                PropertyGroup root = (PropertyGroup)result[0];
                result = root.getChildren();
            }
            return result;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertyGroup) {
                return ((PropertyGroup)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PropertyGroup;
        }
    }

    private final class ProgramButtonListener
    extends SelectionAdapter {
        private ProgramButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean program = true;
            if (ConfigurationComposite.this.device.isOTP() && this.isConfirmOTP()) {
                String title = "One-Time-Programmable Device";
                String message = "Warning: This device is one-time-programmable!\nDo you want to write these settings to the device permanently?";
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(ConfigurationComposite.this.getShell(), title, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, "Always program without asking", false);
                boolean bl = program = dialog.open() == 2;
                if (program && dialog.getToggleState()) {
                    this.setConfirmOTP(false);
                }
            }
            if (program) {
                ConfigurationComposite.this.device.program();
                try {
                    ConfigurationComposite.this.device.resetDevice();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                ConfigurationComposite.this.device.verify();
                ConfigurationComposite.this.vProperties.refresh();
                ConfigurationComposite.this.vBaudRates.refresh();
                ConfigurationComposite.this.vPortConfigs.refresh();
            }
        }

        private void setConfirmOTP(boolean confirm) {
            IPersistentPreferenceStore store = PreferenceConstants.getStore();
            store.setValue("PREF_CONFIRM_OTP", confirm);
            try {
                store.save();
            }
            catch (IOException ioe) {
                MessageLog.error("Failed to save preferences.", ioe);
            }
        }

        private boolean isConfirmOTP() {
            return PreferenceConstants.getStore().getBoolean("PREF_CONFIRM_OTP");
        }
    }

    private static final class PropertyEditingSupport
    extends EditingSupport {
        private Composite tableOrTree;
        private final TextCellEditor textEditor;
        private final ComboBoxCellEditor comboEditor;

        public PropertyEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.tableOrTree = (Composite)viewer.getControl();
            this.textEditor = new TextCellEditor(this.tableOrTree);
            this.comboEditor = new ComboCellEditor(this.tableOrTree, new String[0], 8);
        }

        protected CellEditor getCellEditor(Object element) {
            Property property = (Property)element;
            CellEditor result = null;
            CellEditorFactory factory = property.getCellEditorFactory();
            if (factory != null) {
                result = factory.create(this.tableOrTree, property.getValue());
            }
            if (result == null) {
                if (property.hasItems()) {
                    Item[] items = property.getItems();
                    this.comboEditor.setItems(Item.getDescriptions(items));
                    result = this.comboEditor;
                } else {
                    result = this.textEditor;
                }
            }
            return result;
        }

        protected boolean canEdit(Object element) {
            return !(element instanceof PropertyGroup);
        }

        protected Object getValue(Object element) {
            Property property = (Property)element;
            Object result = property.getValue();
            if (property.hasItems()) {
                int index = Math.max(0, Item.indexOf(property.getItems(), result));
                result = index;
            }
            return result;
        }

        protected void setValue(Object element, Object value) {
            Property property = (Property)element;
            if (property.hasItems()) {
                Integer index = (Integer)value;
                Object[] items = property.getItems();
                try {
                    Item item = items[index];
                    property.setValue(item.getValue());
                }
                catch (RuntimeException exc) {
                    MessageLog.error(String.format("Item not found. Index=%d. Values=%s.", index, Arrays.toString(items)), exc);
                }
            } else {
                property.setValue((String)value);
            }
            this.getViewer().update(element, null);
        }
    }

    private final class PropertyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private final Control control;
        private final int editableColumn;
        private Font boldRowFont;

        public PropertyLabelProvider(Control tableOrTree, int editableColumn) {
            this.control = tableOrTree;
            this.editableColumn = editableColumn;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            Color result = null;
            if (columnIndex == this.editableColumn) {
                Property property = (Property)element;
                if (!(property instanceof PropertyGroup)) {
                    if (property.isError()) {
                        result = ConfigurationComposite.this.errorBg;
                    } else if (property.isWritten()) {
                        result = ConfigurationComposite.this.successBg;
                    } else if (property.isChanged()) {
                        result = ConfigurationComposite.this.changedBg;
                    }
                }
            } else {
                result = Display.getCurrent().getSystemColor(22);
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Property property = (Property)element;
            switch (columnIndex) {
                case 0: {
                    return property.getName();
                }
                case 1: {
                    return property.getDefaultValueString();
                }
                case 2: {
                    return property.getValueString();
                }
            }
            return "";
        }

        public Font getFont(Object element, int columnIndex) {
            if (element instanceof PropertyGroup && columnIndex == 0) {
                return this.getBoldFont();
            }
            return null;
        }

        private Font getBoldFont() {
            if (this.boldRowFont == null) {
                FontData[] fontDatas;
                FontData[] fontDataArray = fontDatas = this.control.getFont().getFontData();
                int n = fontDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    FontData fd = fontDataArray[n2];
                    fd.setStyle(1);
                    ++n2;
                }
                this.boldRowFont = new Font((Device)ConfigurationComposite.this.getDisplay(), fontDatas);
                this.control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        PropertyLabelProvider.this.boldRowFont.dispose();
                    }
                });
            }
            return this.boldRowFont;
        }
    }

    private static final class ResetListener
    extends MouseAdapter {
        private final StructuredViewer viewer;
        private final int resetColumn;

        ResetListener(StructuredViewer viewer, int resetColumn) {
            this.viewer = viewer;
            this.resetColumn = resetColumn;
        }

        public void mouseDown(MouseEvent e) {
            Object rowData;
            Widget item;
            if (e.button == 1 && (item = this.clickedColumn(e, this.resetColumn)) != null && (rowData = item.getData()) instanceof Property) {
                Property property = (Property)rowData;
                property.reset();
                this.viewer.refresh((Object)property, true);
            }
        }

        private Widget clickedColumn(MouseEvent e, int colIndex) {
            TableItem result = null;
            if (e.widget instanceof Table) {
                Table table = (Table)e.widget;
                int colStart = 0;
                int colEnd = 0;
                int i = 0;
                while (i <= colIndex) {
                    TableColumn column = table.getColumn(i);
                    colStart = colEnd;
                    colEnd += column.getWidth();
                    ++i;
                }
                if (colStart <= e.x && e.x <= colEnd) {
                    result = table.getItem(new Point(e.x, e.y));
                }
            } else if (e.widget instanceof Tree) {
                Tree tree = (Tree)e.widget;
                int colStart = 0;
                int colEnd = 0;
                int i = 0;
                while (i <= colIndex) {
                    TreeColumn column = tree.getColumn(i);
                    colStart = colEnd;
                    colEnd += column.getWidth();
                    ++i;
                }
                if (colStart <= e.x && e.x <= colEnd) {
                    result = tree.getItem(new Point(e.x, e.y));
                }
            }
            return result;
        }
    }

    private final class ResetToolTip
    extends CellLabelProvider {
        private ResetToolTip() {
        }

        public String getToolTipText(Object element) {
            return "Reset to device defaults";
        }

        public Point getToolTipShift(Object object) {
            return new Point(13, 2);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof PropertyGroup || cell.getElement() instanceof String) {
                cell.setImage(null);
            } else {
                cell.setImage(ConfigurationComposite.this.imgResetButton);
            }
        }
    }

    private final class ShowDefaultsListener
    implements IPropertyChangeListener {
        ShowDefaultsListener() {
            boolean showDefaults = PreferenceConstants.getStore().getBoolean("PREF_SHOW_DEFAULTS");
            if (!showDefaults) {
                this.updateColumns(showDefaults);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("PREF_SHOW_DEFAULTS".equals(event.getProperty())) {
                boolean show = (Boolean)event.getNewValue();
                this.updateColumns(show);
            }
        }

        private void updateColumns(boolean show) {
            TableColumnLayoutWithToggle tblLayout = (TableColumnLayoutWithToggle)ConfigurationComposite.this.tblProperties.getParent().getLayout();
            tblLayout.setVisible(ConfigurationComposite.this.tblProperties.getColumn(1), show);
            TreeColumnLayoutWithToggle trLayout = (TreeColumnLayoutWithToggle)ConfigurationComposite.this.trPortConfigs.getParent().getLayout();
            trLayout.setVisible(ConfigurationComposite.this.trPortConfigs.getColumn(1), show);
        }
    }
}

