/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.ui;

import com.silabs.customizer.UIConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class Accordeon
extends Composite {
    private final Color backColor;
    private final Color expandedColor;

    public Accordeon(Composite parent, int style, String[] titles) {
        super(parent, style);
        if (titles.length == 0) {
            throw new IllegalArgumentException("Array titles is empty.");
        }
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        String[] stringArray = titles;
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            this.addSection(title);
            ++n2;
        }
        this.expand(this.getChildren()[0]);
        this.backColor = new Color((Device)this.getDisplay(), 187, 187, 187);
        this.expandedColor = new Color((Device)this.getDisplay(), 187, 187, 207);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Accordeon.this.backColor.dispose();
                Accordeon.this.expandedColor.dispose();
            }
        });
    }

    public int getSectionCount() {
        return this.getChildren().length / 2;
    }

    public Composite getSection(int index) {
        int position = index * 2 + 1;
        return (Composite)this.getChildren()[position];
    }

    private void addSection(String title) {
        StyledText header = new StyledText((Composite)this, 8);
        header.setText(title);
        header.setMargins(1, 2, 2, 1);
        new HeaderListener(header);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)header);
        Composite section = new Composite((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
    }

    private void expand(Control header) {
        boolean changed = false;
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Control section = children[i + 1];
            GridData gd = (GridData)section.getLayoutData();
            if (children[i] == header) {
                if (gd.exclude) {
                    gd.exclude = false;
                    section.setSize(section.computeSize(-1, -1));
                    changed = true;
                }
            } else if (!gd.exclude) {
                gd.exclude = true;
                section.setSize(0, 0);
                changed = true;
            }
            children[i].redraw();
            i += 2;
        }
        if (changed) {
            this.layout(true);
        }
    }

    private boolean isExpanded(Control header) {
        boolean result = false;
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (header == children[i]) {
                Control section = children[i + 1];
                GridData gd = (GridData)section.getLayoutData();
                result = !gd.exclude;
            }
            i += 2;
        }
        return result;
    }

    private class HeaderListener
    implements MouseListener,
    MouseTrackListener,
    FocusListener,
    SelectionListener,
    PaintListener {
        private final StyledText header;

        HeaderListener(StyledText header) {
            this.header = header;
            header.addMouseListener((MouseListener)this);
            header.addMouseTrackListener((MouseTrackListener)this);
            header.addFocusListener((FocusListener)this);
            header.addSelectionListener((SelectionListener)this);
            header.addPaintListener((PaintListener)this);
            header.setCursor(this.getCursor(0));
            header.setCaret(null);
        }

        public void mouseEnter(MouseEvent e) {
            this.header.setCursor(this.getCursor(21));
        }

        public void mouseExit(MouseEvent e) {
            this.header.setCursor(this.getCursor(0));
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Accordeon.this.expand((Control)this.header);
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.header.redraw();
        }

        public void focusLost(FocusEvent e) {
            this.header.redraw();
        }

        public void widgetSelected(SelectionEvent e) {
            this.header.setSelection(0, 0);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private Cursor getCursor(int cursor) {
            return this.header.getDisplay().getSystemCursor(cursor);
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Display d = e.display;
            Point headerSize = this.header.getSize();
            gc.setBackground(d.getSystemColor(1));
            gc.fillRectangle(0, 0, headerSize.x, headerSize.y);
            Color bgColor = Accordeon.this.isExpanded((Control)this.header) ? Accordeon.this.expandedColor : Accordeon.this.backColor;
            Pattern p = new Pattern((Device)d, 0.0f, 0.0f, 0.0f, (float)headerSize.y, bgColor, 120, bgColor, 255);
            gc.setBackgroundPattern(p);
            gc.fillRectangle(0, 0, headerSize.x, headerSize.y);
            String text = this.header.getText();
            gc.drawString(text, 1, 2, true);
            Point textSize = gc.stringExtent(text);
            if (this.header.isFocusControl()) {
                if (UIConstants.isWsWindows()) {
                    gc.setLineStyle(6);
                    gc.setLineDash(new int[]{1, 1});
                } else {
                    gc.setLineStyle(3);
                }
                gc.drawRectangle(0, 1, textSize.x + 1, textSize.y);
            }
        }
    }
}

