/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.log;

import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public final class MessageLog {
    private ServiceTracker<LogService, Object> logTracker;
    private boolean isDebug = false;

    public static void debug(Object ... values) {
        MessageLog log = new MessageLog();
        log.logDebug(values);
        log.dispose();
    }

    public static void info(String message) {
        MessageLog log = new MessageLog();
        log.logInfo(message);
        log.dispose();
    }

    public static void error(String message, Exception exc) {
        MessageLog log = new MessageLog();
        log.logError(message, exc);
        log.dispose();
    }

    public MessageLog() {
        Bundle bundle = Platform.getBundle((String)"com.silabs.customizer");
        BundleContext context = bundle.getBundleContext();
        this.logTracker = new ServiceTracker(context, LogService.class.getName(), null);
        this.logTracker.open();
        ServiceTracker debugTracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
        debugTracker.open();
        DebugOptions debugService = (DebugOptions)debugTracker.getService();
        this.isDebug = debugService.isDebugEnabled();
        debugTracker.close();
    }

    public void dispose() {
        this.logTracker.close();
        this.logTracker = null;
    }

    public void logDebug(Object ... values) {
        if (this.isDebug) {
            StringBuilder message = new StringBuilder();
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                message.append(value.toString());
                message.append(" ");
                ++n2;
            }
            this.log(4, message.toString(), null);
        }
    }

    public void logError(String message) {
        this.log(1, message, null);
    }

    public void logError(String message, Exception exc) {
        this.log(1, message, exc);
    }

    public void logInfo(String message) {
        this.log(3, message, null);
    }

    private void log(int level, String message, Exception exc) {
        LogService logService;
        if (message != null && (logService = (LogService)this.logTracker.getService()) != null) {
            logService.log(level, message, (Throwable)exc);
        }
    }
}

