/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.dialogs;

import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.cp211x.Device2114;
import com.silabs.customizer.dialogs.DacStringEditorDialog;
import com.silabs.customizer.dialogs.cp2114regs.ConfigArray;
import com.silabs.customizer.dialogs.cp2114regs.ConfigEnumField;
import com.silabs.customizer.dialogs.cp2114regs.ConfigEnumRegister;
import com.silabs.customizer.dialogs.cp2114regs.ConfigField;
import com.silabs.customizer.dialogs.cp2114regs.ConfigItemLabelProvider;
import com.silabs.customizer.dialogs.cp2114regs.ConfigRegister;
import com.silabs.customizer.dialogs.cp2114regs.EnhancedRegisterList;
import com.silabs.customizer.dialogs.cp2114regs.LegacyRegisterList;
import com.silabs.customizer.dialogs.cp2114regs.RegisterList;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class AudioInterfaceConfigDialog
extends Dialog {
    private Text txtBootConfig;
    private StyledText txtConsole;
    private Combo comboBootConfig;
    private Combo comboOtpSlot;
    private Image imageIcon;
    private Device2114 device;
    private Text txtCurrentConfig;
    private Text txtAvailableBoot;
    private Text txtAvailableConfigs;
    private Text txtAvailableOtp;
    private Text txtDacAddress;
    private Text txtDacCount;
    RegisterTreeContentProvider contentProvider;
    TreeViewer treeViewer;
    private String[] comboIndexString = new String[32];

    public AudioInterfaceConfigDialog(Shell parentShell, Device2114 device) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.device = device;
        this.imageIcon = new Image((Device)AudioInterfaceConfigDialog.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/sls_128x128.png"));
        int i = 0;
        while (i < 32) {
            this.comboIndexString[i] = Integer.toString(i);
            ++i;
        }
    }

    public boolean close() {
        this.imageIcon.dispose();
        return super.close();
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private String askUserForFile(int style, String suggestedFile) {
        FileDialog fileDialog = new FileDialog(this.getShell(), style);
        String[] extensions = new String[]{"*.txt", "*.*"};
        if (suggestedFile != null) {
            fileDialog.setFileName(suggestedFile);
        }
        fileDialog.setFilterExtensions(extensions);
        String path = fileDialog.open();
        return path;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.getShell().setImage(this.imageIcon);
        container.getShell().setText("DAC Configuration");
        container.setLayout((Layout)new GridLayout(2, false));
        Button btnResetDevice = new Button(container, 0);
        btnResetDevice.setToolTipText("Reset the CP2114");
        btnResetDevice.setText("Reset Device");
        btnResetDevice.addSelectionListener((SelectionListener)new ResetDeviceButtonListener());
        new Label(container, 0);
        Group grpCpRegisterConfiguration = new Group(container, 0);
        grpCpRegisterConfiguration.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpCpRegisterConfiguration.setText("CP2114 Audio Configuration");
        grpCpRegisterConfiguration.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer((Composite)grpCpRegisterConfiguration, 65540);
        Tree tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 460;
        tree.setLayoutData((Object)gd_tree);
        tree.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        TreeViewerColumn propertyColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnRegister = propertyColumn.getColumn();
        trclmnRegister.setResizable(false);
        trclmnRegister.setWidth(300);
        trclmnRegister.setText("Register");
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnValue = valueColumn.getColumn();
        trclmnValue.setResizable(false);
        trclmnValue.setWidth(160);
        trclmnValue.setText("Value");
        this.contentProvider = new RegisterTreeContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        propertyColumn.setLabelProvider((CellLabelProvider)new PropertyColumnLabelProvider());
        valueColumn.setLabelProvider((CellLabelProvider)new ValueColumnLabelProvider());
        this.treeViewer.setInput((Object)this.contentProvider);
        valueColumn.setEditingSupport((EditingSupport)new ConfigItemEditingSupport((ColumnViewer)this.treeViewer));
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 2 || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)32);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group grpConfiguration = new Group(composite, 0);
        grpConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpConfiguration.setText("Configuration");
        grpConfiguration.setLayout((Layout)new GridLayout(2, false));
        Button btnReadFromFile = new Button((Composite)grpConfiguration, 0);
        btnReadFromFile.setToolTipText("Read configuration data from a file");
        btnReadFromFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnReadFromFile.setText("Read from File");
        btnReadFromFile.addSelectionListener((SelectionListener)new LoadConfigButtonListener());
        new Label((Composite)grpConfiguration, 0);
        Button btnSaveToFile = new Button((Composite)grpConfiguration, 0);
        btnSaveToFile.setToolTipText("Save configuration data to a file");
        btnSaveToFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSaveToFile.setText("Save to File");
        btnSaveToFile.addSelectionListener((SelectionListener)new SaveConfigButtonListener());
        new Label((Composite)grpConfiguration, 0);
        Button btnReadFromOtp = new Button((Composite)grpConfiguration, 0);
        btnReadFromOtp.setToolTipText("Read a specific configuration slot from the device OTP memory");
        btnReadFromOtp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnReadFromOtp.setText("Read From OTP");
        btnReadFromOtp.addSelectionListener((SelectionListener)new ReadConfigButtonListener());
        this.comboOtpSlot = new Combo((Composite)grpConfiguration, 0);
        this.comboOtpSlot.setToolTipText("Select which OTP slot to use for configuration reading");
        this.comboOtpSlot.setItems(this.comboIndexString);
        this.comboOtpSlot.select(0);
        this.comboOtpSlot.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnWriteToOtp = new Button((Composite)grpConfiguration, 0);
        btnWriteToOtp.setToolTipText("Writes the configuration to a new free slot in the OTP.\nThis will fail if there are no available slots or not\nenough OTP memory.");
        btnWriteToOtp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnWriteToOtp.setText("Write to OTP");
        btnWriteToOtp.addSelectionListener((SelectionListener)new WriteConfigTextOTPButtonListener());
        new Label((Composite)grpConfiguration, 0);
        Button btnSetBoot = new Button((Composite)grpConfiguration, 0);
        btnSetBoot.setToolTipText("Program the configuration number to use\nwhen the device boots.  This will use up\none boot config index.");
        btnSetBoot.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSetBoot.setText("Set Boot");
        btnSetBoot.addSelectionListener((SelectionListener)new SetBootConfigButtonListener());
        this.comboBootConfig = new Combo((Composite)grpConfiguration, 0);
        this.comboBootConfig.setToolTipText("Select which OTP slot to use for boot");
        this.comboBootConfig.setItems(this.comboIndexString);
        this.comboBootConfig.select(0);
        this.comboBootConfig.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnWriteEntireConfig = new Button(composite, 0);
        btnWriteEntireConfig.setToolTipText("Write the entire configuration memory to a file.\nThis will include all configurations in the OTP.");
        btnWriteEntireConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnWriteEntireConfig.setText("Write Entire OTP to File");
        btnWriteEntireConfig.addSelectionListener((SelectionListener)new SaveFinalButtonListener());
        Group grpCapabilities = new Group(composite, 0);
        grpCapabilities.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpCapabilities.setText("Capabilities");
        grpCapabilities.setLayout((Layout)new GridLayout(2, false));
        Label lblCurrentConfig = new Label((Composite)grpCapabilities, 0);
        lblCurrentConfig.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCurrentConfig.setText("Current Config");
        this.txtCurrentConfig = new Text((Composite)grpCapabilities, 2056);
        this.txtCurrentConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtCurrentConfig.setToolTipText("Shows the current boot configuration number");
        Label lblAvailableBoot = new Label((Composite)grpCapabilities, 0);
        lblAvailableBoot.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailableBoot.setText("Available Boot");
        this.txtAvailableBoot = new Text((Composite)grpCapabilities, 2048);
        this.txtAvailableBoot.setToolTipText("The number of available boot indices.  One of\nthese is used each time you set the boot configuration.");
        this.txtAvailableBoot.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblAvailableConfigs = new Label((Composite)grpCapabilities, 0);
        lblAvailableConfigs.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailableConfigs.setText("Available Configs");
        this.txtAvailableConfigs = new Text((Composite)grpCapabilities, 2048);
        this.txtAvailableConfigs.setToolTipText("The number of available OTP configuration slots.\nOne is used each time you write a configuration\nto OTP.");
        this.txtAvailableConfigs.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblAvailableOtp = new Label((Composite)grpCapabilities, 0);
        lblAvailableOtp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailableOtp.setText("Available OTP");
        this.txtAvailableOtp = new Text((Composite)grpCapabilities, 2048);
        this.txtAvailableOtp.setToolTipText("The available OTP memory space for holding\nconfiguration data.  This is used each time you\nwrite a configuration to OTP.");
        this.txtAvailableOtp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.getCapabilities();
        Point compSize = composite.computeSize(-1, -1, false);
        gd_tree.heightHint = compSize.y;
        tree.setLayoutData((Object)gd_tree);
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Group grpDacRegisters = new Group(container, 0);
        grpDacRegisters.setLayout((Layout)new GridLayout(8, false));
        grpDacRegisters.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpDacRegisters.setText("DAC Registers");
        Label lblAddress = new Label((Composite)grpDacRegisters, 0);
        lblAddress.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAddress.setText("Address");
        this.txtDacAddress = new Text((Composite)grpDacRegisters, 2048);
        Label lblCount = new Label((Composite)grpDacRegisters, 0);
        lblCount.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCount.setText("Count");
        this.txtDacCount = new Text((Composite)grpDacRegisters, 2048);
        Button btnReadDac = new Button((Composite)grpDacRegisters, 0);
        btnReadDac.setText("Read");
        btnReadDac.addSelectionListener((SelectionListener)new GetDacRegistersButtonListener());
        new Label((Composite)grpDacRegisters, 0);
        new Label((Composite)grpDacRegisters, 0);
        new Label((Composite)grpDacRegisters, 0);
        Group grpLog = new Group(container, 0);
        grpLog.setLayout((Layout)new GridLayout(1, false));
        GridData gd_txtLog = new GridData(4, 4, true, true, 2, 1);
        gd_txtLog.heightHint = 100;
        grpLog.setLayoutData((Object)gd_txtLog);
        grpLog.setText("Log");
        this.txtConsole = new StyledText((Composite)grpLog, 2048);
        GridData gd_txtConsole = new GridData(4, 4, true, true, 1, 1);
        gd_txtConsole.heightHint = 60;
        this.txtConsole.setLayoutData((Object)gd_txtConsole);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Close", false);
    }

    private void printConsole(String printStr) {
        this.txtConsole.append(printStr);
        this.txtConsole.setTopIndex(this.txtConsole.getLineCount() - 1);
    }

    private void getCapabilities() {
        try {
            try {
                byte[] pCapsStruct = new byte[5];
                this.device.getDeviceCaps(pCapsStruct);
                this.txtCurrentConfig.setText(Integer.toString(pCapsStruct[2] & 0xFF));
                this.txtAvailableBoot.setText(Integer.toString(pCapsStruct[0] & 0xFF));
                this.txtAvailableConfigs.setText(Integer.toString(pCapsStruct[1] & 0xFF));
                int availOtp = pCapsStruct[3] & 0xFF;
                this.txtAvailableOtp.setText(Integer.toString(availOtp |= (pCapsStruct[4] & 0xFF) << 8));
            }
            catch (Exception e) {
                this.txtCurrentConfig.setText("ERR");
                this.txtAvailableBoot.setText("ERR");
                this.txtAvailableConfigs.setText("ERR");
                this.txtAvailableOtp.setText("ERR");
                this.printConsole("* Error getting CP2114 Caps\n\n");
                e.printStackTrace();
                DeviceDetector.getDefault().start();
            }
        }
        finally {
            DeviceDetector.getDefault().start();
        }
    }

    private class ConfigItemEditingSupport
    extends EditingSupport {
        private ColumnViewer viewer;

        public ConfigItemEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof ConfigArray) {
                ConfigArrayDialogCellEditor ce = new ConfigArrayDialogCellEditor((Composite)this.viewer.getControl(), (ConfigArray)element);
                return ce;
            }
            if (element instanceof ConfigEnumRegister) {
                ConfigEnumRegister enumReg = (ConfigEnumRegister)element;
                ComboBoxCellEditor cbe = new ComboBoxCellEditor((Composite)this.viewer.getControl(), enumReg.getNames(), 8);
                cbe.setValue((Object)enumReg.getIndexForValue(enumReg.getValue()));
                cbe.setActivationStyle(1);
                CCombo combo = (CCombo)cbe.getControl();
                combo.addSelectionListener((SelectionListener)new ComboSelectionListener());
                return cbe;
            }
            if (element instanceof ConfigRegister) {
                ConfigRegister reg = (ConfigRegister)element;
                if (reg.getFields() == null) {
                    return new TextCellEditor((Composite)this.viewer.getControl());
                }
                return null;
            }
            if (element instanceof ConfigEnumField) {
                ConfigEnumField enumField = (ConfigEnumField)element;
                ComboBoxCellEditor cbe = new ComboBoxCellEditor((Composite)this.viewer.getControl(), enumField.getNames(), 8);
                cbe.setValue((Object)enumField.getIndexForValue(enumField.getValue()));
                cbe.setActivationStyle(1);
                CCombo combo = (CCombo)cbe.getControl();
                combo.addSelectionListener((SelectionListener)new ComboSelectionListener());
                return cbe;
            }
            if (element instanceof ConfigField) {
                return new TextCellEditor((Composite)this.viewer.getControl());
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            ConfigRegister reg;
            return element instanceof ConfigRegister ? (reg = (ConfigRegister)element).getFields() == null : element instanceof ConfigField;
        }

        protected Object getValue(Object element) {
            if (element instanceof ConfigArray) {
                return ((ConfigArray)element).getValuesString();
            }
            if (element instanceof ConfigEnumRegister) {
                ConfigEnumRegister reg = (ConfigEnumRegister)element;
                return reg.getIndexForValue(reg.getValue());
            }
            if (element instanceof ConfigEnumField) {
                ConfigEnumField field = (ConfigEnumField)element;
                return field.getIndexForValue(field.getValue());
            }
            ConfigItemLabelProvider provider = (ConfigItemLabelProvider)element;
            return provider.getValueLabel();
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ConfigArray) {
                ConfigArray ca = (ConfigArray)element;
                ca.setValuesString((String)value);
            } else if (element instanceof ConfigEnumRegister) {
                ConfigEnumRegister reg = (ConfigEnumRegister)element;
                int enumIndex = (Integer)value;
                reg.setValue(reg.getValueForIndex(enumIndex));
                this.viewer.update((Object)reg, null);
            } else if (element instanceof ConfigRegister) {
                ConfigRegister reg = (ConfigRegister)element;
                if (reg.getFields() == null) {
                    try {
                        reg.setValue(Integer.decode((String)value).byteValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageDialog.openInformation((Shell)AudioInterfaceConfigDialog.this.getShell(), (String)"Number Format Error", (String)"Error decoding the number. \nPlease use 0x for hexadecimal values.");
                    }
                }
            } else if (element instanceof ConfigEnumField) {
                ConfigEnumField field = (ConfigEnumField)element;
                int enumIndex = (Integer)value;
                field.setValue(field.getValueForIndex(enumIndex));
                this.viewer.update((Object)field.getParent(), null);
            } else if (element instanceof ConfigField) {
                ConfigField field = (ConfigField)element;
                field.setValue(Integer.decode((String)value).byteValue());
                this.viewer.update((Object)field.getParent(), null);
            }
            this.viewer.update(element, null);
        }

        private class ComboSelectionListener
        implements SelectionListener {
            private ComboSelectionListener() {
            }

            public void widgetSelected(SelectionEvent ev) {
                ((TreeViewer)ConfigItemEditingSupport.this.viewer).getTree().forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent ev) {
            }
        }

        private class ConfigArrayDialogCellEditor
        extends DialogCellEditor {
            private ConfigArray ca;

            public ConfigArrayDialogCellEditor(Composite parent, ConfigArray configArray) {
                super(parent);
                this.ca = configArray;
            }

            protected Object openDialogBox(Control cellEditorWindow) {
                DacStringEditorDialog dlg = new DacStringEditorDialog(this.getControl().getShell(), this.ca.getValuesString());
                int result = dlg.open();
                return result == 0 ? dlg.getText() : null;
            }
        }
    }

    public class GetDacRegistersButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            try {
                try {
                    byte[] pCP2114RamConfigStruct = new byte[32];
                    AudioInterfaceConfigDialog.this.device.getRamConfig(pCP2114RamConfigStruct);
                    int numBytes = ((pCP2114RamConfigStruct[5] & 8) >> 3) + 1;
                    Integer intValue = Integer.parseInt(AudioInterfaceConfigDialog.this.txtDacAddress.getText(), 16);
                    if (intValue > 255) {
                        AudioInterfaceConfigDialog.this.txtDacAddress.setText(String.format("%02X", intValue & 0xFF));
                        AudioInterfaceConfigDialog.this.printConsole("* Error, invalid argument\n");
                        throw new IllegalArgumentException();
                    }
                    AudioInterfaceConfigDialog.this.txtDacAddress.setText(String.format("%02X", intValue));
                    byte[] dacStartAddress = DatatypeConverter.parseHexBinary((String)AudioInterfaceConfigDialog.this.txtDacAddress.getText());
                    intValue = Integer.parseInt(AudioInterfaceConfigDialog.this.txtDacCount.getText(), 16);
                    if (intValue > 255) {
                        AudioInterfaceConfigDialog.this.txtDacCount.setText(String.format("%02X", intValue & 0xFF));
                        AudioInterfaceConfigDialog.this.printConsole("* Error, invalid argument\n");
                        throw new IllegalArgumentException();
                    }
                    AudioInterfaceConfigDialog.this.txtDacCount.setText(String.format("%02X", intValue));
                    byte[] dacRegistersToRead = DatatypeConverter.parseHexBinary((String)AudioInterfaceConfigDialog.this.txtDacCount.getText());
                    byte[] pDacConfigBuffer = new byte[numBytes * dacRegistersToRead[0]];
                    AudioInterfaceConfigDialog.this.device.getDacRegisters(dacStartAddress[0], dacRegistersToRead[0], pDacConfigBuffer);
                    AudioInterfaceConfigDialog.this.printConsole("* DAC Registers:\n");
                    int i = 0;
                    while (i < pDacConfigBuffer.length) {
                        AudioInterfaceConfigDialog.this.printConsole(String.format("0x%02X", pDacConfigBuffer[i]));
                        if (i + 1 < pDacConfigBuffer.length) {
                            AudioInterfaceConfigDialog.this.printConsole(", ");
                        } else {
                            AudioInterfaceConfigDialog.this.printConsole("\n\n");
                        }
                        ++i;
                    }
                }
                catch (Exception exc) {
                    AudioInterfaceConfigDialog.this.printConsole("* Error getting DAC Config\n\n");
                    exc.printStackTrace();
                    DeviceDetector.getDefault().start();
                }
            }
            finally {
                DeviceDetector.getDefault().start();
            }
        }
    }

    public class LoadConfigButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            block8: {
                DeviceDetector.getDefault().stop();
                RegisterList registerList = AudioInterfaceConfigDialog.this.contentProvider.getRegisterList();
                ByteArrayOutputStream regByteStream = new ByteArrayOutputStream();
                try {
                    try {
                        String path = AudioInterfaceConfigDialog.this.askUserForFile(4096, "ConfigData.txt");
                        if (path != null) {
                            String lineText;
                            AudioInterfaceConfigDialog.this.printConsole("Reading configuration from file: " + path + "\n");
                            FileReader file = new FileReader(path);
                            BufferedReader textReader = new BufferedReader(file);
                            block5: while ((lineText = textReader.readLine()) != null) {
                                String[] words = lineText.split("[ ,\t]+");
                                int i = 0;
                                while (i < words.length) {
                                    if (words[i].contains("#")) continue block5;
                                    regByteStream.write(Integer.valueOf(words[i], 16).byteValue());
                                    ++i;
                                }
                            }
                            registerList.setAllConfigRegisterValues(regByteStream.toByteArray());
                            AudioInterfaceConfigDialog.this.treeViewer.setInput((Object)AudioInterfaceConfigDialog.this.contentProvider);
                            file.close();
                            AudioInterfaceConfigDialog.this.printConsole("... read " + regByteStream.size() + " bytes\n");
                            break block8;
                        }
                        AudioInterfaceConfigDialog.this.printConsole("File path is null\n");
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        DeviceDetector.getDefault().start();
                    }
                }
                finally {
                    DeviceDetector.getDefault().start();
                }
            }
        }
    }

    private class PropertyColumnLabelProvider
    extends ColumnLabelProvider {
        private PropertyColumnLabelProvider() {
        }

        public String getText(Object element) {
            ConfigItemLabelProvider reg = (ConfigItemLabelProvider)element;
            return reg.getName();
        }

        public String getToolTipText(Object element) {
            ConfigItemLabelProvider reg = (ConfigItemLabelProvider)element;
            return reg.getDescription();
        }
    }

    public class ReadConfigButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            try {
                try {
                    byte cp2114ConfigNumber = (byte)Integer.parseInt(AudioInterfaceConfigDialog.this.comboOtpSlot.getText());
                    byte[] pCP2114ConfigStruct = new byte[1024];
                    int status = AudioInterfaceConfigDialog.this.device.getOtpConfig(cp2114ConfigNumber, pCP2114ConfigStruct);
                    switch (status) {
                        case 0: {
                            AudioInterfaceConfigDialog.this.contentProvider.setRegisterValues(pCP2114ConfigStruct);
                            AudioInterfaceConfigDialog.this.printConsole("Read configuration from OTP " + cp2114ConfigNumber + "\n");
                            break;
                        }
                        case 65: {
                            AudioInterfaceConfigDialog.this.printConsole("* ERROR: CP2114 reports unexpected cache data.\n\n");
                            break;
                        }
                        case 32: {
                            AudioInterfaceConfigDialog.this.printConsole("* ERROR: Invalid DAC config index.\n\n");
                            break;
                        }
                        case 34: {
                            AudioInterfaceConfigDialog.this.printConsole("* ERROR: Requested DAC config is not programmed.\n\n");
                            break;
                        }
                        default: {
                            AudioInterfaceConfigDialog.this.printConsole("* Unknown error getting DAC OTP Config\n\n");
                            break;
                        }
                    }
                }
                catch (Exception exc) {
                    AudioInterfaceConfigDialog.this.printConsole("* Unknown error getting DAC OTP Config\n\n");
                    exc.printStackTrace();
                    DeviceDetector.getDefault().start();
                }
            }
            finally {
                DeviceDetector.getDefault().start();
            }
        }
    }

    private class RegisterTreeContentProvider
    implements ITreeContentProvider {
        private RegisterList registerList;

        public RegisterTreeContentProvider() {
            this.registerList = AudioInterfaceConfigDialog.this.device.getFwVersion() >= 8 ? new EnhancedRegisterList() : new LegacyRegisterList();
        }

        public void setRegisterValues(byte[] registerValues) {
            int totalLength = (registerValues[0] & 0xFF) + ((registerValues[1] & 0xFF) << 8);
            ByteBuffer bb = ByteBuffer.allocate(totalLength -= 2);
            bb.put(registerValues, 2, totalLength);
            this.registerList.setAllConfigRegisterValues(bb.array());
            AudioInterfaceConfigDialog.this.treeViewer.setInput((Object)AudioInterfaceConfigDialog.this.contentProvider);
        }

        public RegisterList getRegisterList() {
            return this.registerList;
        }

        public byte[] getRegisterValues() {
            return this.registerList.getAllConfigRegisterValues();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ConfigRegister) {
                return ((ConfigRegister)parentElement).getFields();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<ConfigRegister> elements = new ArrayList<ConfigRegister>(Arrays.asList(this.registerList.getRegisterList()));
            elements.add(this.registerList.getDacConfigArray());
            return elements.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof ConfigField) {
                return ((ConfigField)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            ConfigRegister reg;
            return element instanceof ConfigRegister && (reg = (ConfigRegister)element).getFields() != null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ResetDeviceButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            try {
                AudioInterfaceConfigDialog.this.device.resetDevice();
                AudioInterfaceConfigDialog.this.getCapabilities();
                AudioInterfaceConfigDialog.this.printConsole("Resetting device\n");
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public class SaveConfigButtonListener
    extends SelectionAdapter {
        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            registerList = AudioInterfaceConfigDialog.this.contentProvider.getRegisterList();
            configRegs = registerList.getRegisterList();
            dacVals = registerList.getDacConfigArray().getValues();
            try {
                path = AudioInterfaceConfigDialog.access$3(AudioInterfaceConfigDialog.this, 4096, "ConfigData.txt");
                if (path == null) ** GOTO lbl17
                f = new File(path);
                if (f.exists() && !(doOverwrite = MessageDialog.openConfirm((Shell)AudioInterfaceConfigDialog.this.getShell(), (String)"Overwrite existing file?", (String)path))) {
                    return;
                }
                AudioInterfaceConfigDialog.access$2(AudioInterfaceConfigDialog.this, "Writing configuration to file: " + path + "\n");
                file = new FileWriter(path);
                file.write("# 201512\n");
                i = 0;
                if (true) ** GOTO lbl30
lbl17:
                // 1 sources

                AudioInterfaceConfigDialog.access$2(AudioInterfaceConfigDialog.this, "File path is null\n");
                return;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return;
            }
            finally {
                DeviceDetector.getDefault().start();
            }
            do {
                reg = configRegs[i];
                hexString = String.format("%02X # %s\n", new Object[]{reg.getValue() & 255, reg.getName()});
                file.write(hexString);
                ++i;
lbl30:
                // 2 sources

            } while (i < configRegs.length);
            file.write("# DAC config\n");
            i = 0;
            while (i < dacVals.length) {
                hexString = String.format("%02X\n", new Object[]{dacVals[i]});
                file.write(hexString);
                ++i;
            }
            file.close();
            AudioInterfaceConfigDialog.access$2(AudioInterfaceConfigDialog.this, "... wrote " + (configRegs.length + dacVals.length) + " bytes\n");
        }
    }

    public class SaveFinalButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            int totalConfigSize = AudioInterfaceConfigDialog.this.device.getFwVersion() >= 8 ? 32768 : 6144;
            try {
                try {
                    byte[] config = new byte[totalConfigSize];
                    AudioInterfaceConfigDialog.this.device.readOtp(26624, config, totalConfigSize);
                    String path = AudioInterfaceConfigDialog.this.askUserForFile(8192, "ConfigCP2114Final.txt");
                    if (path != null) {
                        FileWriter file = new FileWriter(path);
                        int i = 0;
                        while (i < totalConfigSize) {
                            file.write(String.format(" %02X\r\n", config[i]));
                            ++i;
                        }
                        file.close();
                        AudioInterfaceConfigDialog.this.printConsole("* Successfully saved final device customization to file \n\n");
                    }
                }
                catch (Exception exc) {
                    AudioInterfaceConfigDialog.this.printConsole("* Error saving final device customization to file\n\n");
                    exc.printStackTrace();
                    DeviceDetector.getDefault().start();
                }
            }
            finally {
                DeviceDetector.getDefault().start();
            }
        }
    }

    public class SetBootConfigButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            try {
                try {
                    Integer intValue = Integer.parseInt(AudioInterfaceConfigDialog.this.txtBootConfig.getText(), 16);
                    if (intValue > 255) {
                        AudioInterfaceConfigDialog.this.txtBootConfig.setText(String.format("%02X", intValue & 0xFF));
                        AudioInterfaceConfigDialog.this.printConsole("* Error, invalid argument\n");
                        throw new IllegalArgumentException();
                    }
                    AudioInterfaceConfigDialog.this.txtBootConfig.setText(String.format("%02X", intValue));
                    byte[] cp2114ConfigNumber = DatatypeConverter.parseHexBinary((String)AudioInterfaceConfigDialog.this.txtBootConfig.getText());
                    int status = AudioInterfaceConfigDialog.this.device.setBootConfig(cp2114ConfigNumber[0]);
                    switch (status) {
                        case 0: {
                            AudioInterfaceConfigDialog.this.printConsole("* Successful Set CP2114 Boot Config: " + String.format("0x%02X\n\n", cp2114ConfigNumber[0]));
                            break;
                        }
                        case 32: {
                            AudioInterfaceConfigDialog.this.printConsole("* ERROR: Invalid CP2114 config index.\n\n");
                            break;
                        }
                        case 34: {
                            AudioInterfaceConfigDialog.this.printConsole("* Request ignored: the specified CP2114 configuration is not programmed.\n\n");
                            break;
                        }
                        case 33: {
                            AudioInterfaceConfigDialog.this.printConsole("* All CP2114 boot config indices have been used.\n\n");
                            break;
                        }
                        case 38: {
                            AudioInterfaceConfigDialog.this.printConsole("* Request ignored: The specified index is already the current boot index.\n\n");
                            break;
                        }
                        default: {
                            AudioInterfaceConfigDialog.this.printConsole("* Unknown error setting CP2114 Boot OTP Config\n\n");
                            break;
                        }
                    }
                }
                catch (Exception exc) {
                    AudioInterfaceConfigDialog.this.printConsole("* Unknown error setting CP2114 Boot OTP Config\n\n");
                    exc.printStackTrace();
                    DeviceDetector.getDefault().start();
                }
            }
            finally {
                DeviceDetector.getDefault().start();
            }
        }
    }

    private class ValueColumnLabelProvider
    extends ColumnLabelProvider {
        private ValueColumnLabelProvider() {
        }

        public String getText(Object element) {
            ConfigItemLabelProvider reg = (ConfigItemLabelProvider)element;
            return reg.getValueLabel();
        }

        public String getToolTipText(Object element) {
            ConfigItemLabelProvider reg = (ConfigItemLabelProvider)element;
            return reg.getDescription();
        }
    }

    public class WriteConfigTextOTPButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            try {
                try {
                    byte[] pBuffer = AudioInterfaceConfigDialog.this.contentProvider.getRegisterValues();
                    AudioInterfaceConfigDialog.this.device.createOtpConfig((short)pBuffer.length, pBuffer);
                    AudioInterfaceConfigDialog.this.printConsole("* Successful writing config data to OTP\n\n");
                }
                catch (Exception exc) {
                    AudioInterfaceConfigDialog.this.printConsole("* Error writing config data to OTP\n\n");
                    exc.printStackTrace();
                    DeviceDetector.getDefault().start();
                }
            }
            finally {
                DeviceDetector.getDefault().start();
            }
        }
    }

    public class WriteConfigTextRAMButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            DeviceDetector.getDefault().stop();
            try {
                try {
                    byte[] pBuffer = AudioInterfaceConfigDialog.this.contentProvider.getRegisterValues();
                    byte[] ramConfigStruct = new byte[32];
                    ramConfigStruct[0] = (byte)(pBuffer.length & 0xFF);
                    ramConfigStruct[1] = (byte)((pBuffer.length & 0xFF00) >> 8);
                    System.arraycopy(pBuffer, 0, ramConfigStruct, 2, 30);
                    byte[] dacRegisters = new byte[pBuffer.length - 32 + 2];
                    System.arraycopy(pBuffer, 30, dacRegisters, 0, pBuffer.length - 32 + 2);
                    int status = AudioInterfaceConfigDialog.this.device.setRamConfig(ramConfigStruct);
                    switch (status) {
                        case 0: {
                            AudioInterfaceConfigDialog.this.printConsole("* Successful writing config text to RAM.\n\n");
                            break;
                        }
                        case 39: {
                            AudioInterfaceConfigDialog.this.printConsole("* SetRamConfig ignored: The CP2114 RAM is unchanged.\n\n");
                            break;
                        }
                        case 35: {
                            AudioInterfaceConfigDialog.this.printConsole("* SetRamConfig rejected: CP2114 RAM Config contains invalid parameters.\n\n");
                            break;
                        }
                        default: {
                            AudioInterfaceConfigDialog.this.printConsole("* Unexpected return in writing config text to RAM.\n\n");
                        }
                    }
                    AudioInterfaceConfigDialog.this.device.setDacRegisters(dacRegisters, (byte)dacRegisters.length);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    DeviceDetector.getDefault().start();
                }
            }
            finally {
                DeviceDetector.getDefault().start();
            }
        }
    }
}

