/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x.XMLtoHEX;

import com.silabs.customizer.devices.cp261x.XMLtoHEX.Descriptor;
import com.silabs.customizer.devices.cp261x.XMLtoHEX.Field;
import com.silabs.customizer.devices.cp261x.XMLtoHEX.Parameter;
import com.silabs.customizer.devices.cp261x.XMLtoHEX.ParameterGroup;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class VarArray {
    Element node;

    public VarArray(Element varNode) {
        this.node = varNode;
    }

    public int length() {
        return 4;
    }

    public int varLength() {
        int ret = 0;
        for (Element child : this.node.getChildren()) {
            String childName = child.getName();
            if (childName.equals("field")) {
                Field field = new Field(child);
                ret += field.length();
                continue;
            }
            if (childName.equals("descriptor")) {
                Descriptor desc = new Descriptor(child);
                ret += desc.length();
                continue;
            }
            if (childName.equals("parameter")) {
                Parameter parm = new Parameter(child);
                ret += parm.length();
                continue;
            }
            if (!childName.equals("parametergroup")) continue;
            ParameterGroup parmgroup = new ParameterGroup(child);
            ret += parmgroup.length();
        }
        return ret;
    }

    public int renderForC(int offset, PrintStream outStream, PrintStream varStream) {
        String childName;
        Attribute nameAttr = this.node.getAttribute("name");
        if (nameAttr == null) {
            outStream.println("Missing name attribute for vararry");
        }
        int length = this.varLength();
        outStream.printf("  // vararry: %s\n", nameAttr.getValue());
        outStream.printf("  // { offset=%d, length=%d }\n", offset, length);
        varStream.printf("  ////////////////\n", new Object[0]);
        varStream.printf("  // vararry: %s\n", nameAttr.getValue());
        varStream.printf("  // { offset=%d, length=%d }\n", offset, length);
        for (Element child : this.node.getChildren()) {
            childName = child.getName();
            if (!childName.equals("comment")) break;
            outStream.printf("  // %s\n", child.getText());
            varStream.printf("  // %s\n", child.getText());
        }
        outStream.printf("  %d, %d, %d, %d,\n\n", offset >> 8 & 0xFF, offset & 0xFF, length >> 8 & 0xFF, length & 0xFF);
        varStream.printf("\n", new Object[0]);
        for (Element child : this.node.getChildren()) {
            childName = child.getName();
            if (childName.equals("field")) {
                Field field = new Field(child);
                field.renderForC(varStream);
                continue;
            }
            if (childName.equals("descriptor")) {
                Descriptor desc = new Descriptor(child);
                desc.renderForC(varStream);
                continue;
            }
            if (childName.equals("parameter")) {
                Parameter parm = new Parameter(child);
                parm.renderForC(varStream);
                continue;
            }
            if (!childName.equals("parametergroup")) continue;
            ParameterGroup parmgroup = new ParameterGroup(child);
            parmgroup.renderForC(varStream);
        }
        return length;
    }

    public int renderForBin(int offset, OutputStream outStream, OutputStream varStream) {
        Attribute nameAttr = this.node.getAttribute("name");
        if (nameAttr == null) {
            return 0;
        }
        int length = this.varLength();
        try {
            outStream.write(offset >> 8 & 0xFF);
            outStream.write(offset & 0xFF);
            outStream.write(length >> 8 & 0xFF);
            outStream.write(length & 0xFF);
        }
        catch (IOException iOException) {
            System.out.println("Error writing to binary output stream in VarArray::renderForBin()");
            System.exit(1);
        }
        for (Element child : this.node.getChildren()) {
            String childName = child.getName();
            if (childName.equals("field")) {
                Field field = new Field(child);
                field.renderForBin(varStream);
                continue;
            }
            if (childName.equals("descriptor")) {
                Descriptor desc = new Descriptor(child);
                desc.renderForBin(varStream);
                continue;
            }
            if (childName.equals("parameter")) {
                Parameter parm = new Parameter(child);
                parm.renderForBin(varStream);
                continue;
            }
            if (!childName.equals("parametergroup")) continue;
            ParameterGroup parmgroup = new ParameterGroup(child);
            parmgroup.renderForBin(varStream);
        }
        return length;
    }
}

