/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x.XMLtoHEX;

import com.silabs.customizer.devices.cp261x.XMLtoHEX.Field;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;

public class Descriptor {
    Element rootNode;
    private static final Map<String, String> usbNameMap = new HashMap<String, String>();

    static {
        usbNameMap.put("DEVICE", "0x01");
        usbNameMap.put("CONFIGURATION", "0x02");
        usbNameMap.put("STRING", "0x03");
        usbNameMap.put("INTERFACE", "0x04");
        usbNameMap.put("ENDPOINT", "0x05");
        usbNameMap.put("AUDIO", "0x01");
        usbNameMap.put("AUDIOCONTROL", "0x01");
        usbNameMap.put("AUDIOSTREAMING", "0x02");
        usbNameMap.put("CS_DEVICE", "0x21");
        usbNameMap.put("CS_CONFIGURATION", "0x22");
        usbNameMap.put("CS_STRING", "0x23");
        usbNameMap.put("CS_INTERFACE", "0x24");
        usbNameMap.put("CS_ENDPOINT", "0x25");
        usbNameMap.put("HEADER", "0x01");
        usbNameMap.put("INPUT_TERMINAL", "0x02");
        usbNameMap.put("OUTPUT_TERMINAL", "0x03");
        usbNameMap.put("MIXER_UNIT", "0x04");
        usbNameMap.put("SELECTOR_UNIT", "0x05");
        usbNameMap.put("FEATURE_UNIT", "0x06");
        usbNameMap.put("PROCESSING_UNIT", "0x07");
        usbNameMap.put("EXTENSION_UNIT", "0x08");
        usbNameMap.put("AS_GENERAL", "0x01");
        usbNameMap.put("FORMAT_TYPE", "0x02");
        usbNameMap.put("FORMAT_SPECIFIC", "0x03");
        usbNameMap.put("EP_GENERAL", "0x01");
        usbNameMap.put("USB_STREAMING", "0x0101");
        usbNameMap.put("MICROPHONE", "0x0201");
        usbNameMap.put("SPEAKER", "0x0301");
        usbNameMap.put("HEADPHONES", "0x0302");
        usbNameMap.put("LINE_CONNECTOR", "0x0603");
        usbNameMap.put("PCM", "0x01");
        usbNameMap.put("FORMAT_TYPE_I", "0x01");
    }

    public Descriptor(Element descNode) {
        this.rootNode = descNode;
    }

    void updateTotalLength() {
        for (Element child : this.rootNode.getChildren()) {
            Attribute typeAttr;
            Attribute nameAttr;
            String childName = child.getName();
            if (!childName.equals("field") || !(nameAttr = child.getAttribute("name")).getValue().equals("wTotalLength") || !(typeAttr = child.getAttribute("type")).getValue().equals("computed")) continue;
            Element valueNode = child.getChild("value");
            valueNode.setText("" + this.length());
            child.setAttribute("type", "num");
            break;
        }
    }

    public void renderForC(PrintStream outStream) {
        Attribute typeAttr = this.rootNode.getAttribute("type");
        if (typeAttr == null) {
            outStream.println("Missing type attribute");
            return;
        }
        this.updateTotalLength();
        outStream.printf("  //--------------\n", new Object[0]);
        outStream.printf("  // descriptor type: %s\n", typeAttr.getValue());
        Element comment = this.rootNode.getChild("comment");
        if (comment != null) {
            outStream.printf("  // %s\n\n", comment.getText());
        }
        for (Element child : this.rootNode.getChildren()) {
            if (child.getName().equals("field")) {
                Element valueNode;
                String substKey;
                String substVal;
                Attribute typeSubst = child.getAttribute("type");
                if (typeSubst != null && typeSubst.getValue().equals("subst") && (substVal = usbNameMap.get(substKey = (valueNode = child.getChild("value")).getValue())) != null) {
                    valueNode.setText(substVal);
                    child.setAttribute("type", "hex");
                    child.setAttribute("order", "le");
                    Element commentNode = child.getChild("comment");
                    if (commentNode == null) {
                        commentNode = new Element("comment");
                        commentNode.setText(substKey);
                        child.addContent(0, (Content)commentNode);
                    }
                }
                Field field = new Field(child);
                field.renderForC(outStream);
                continue;
            }
            if (!child.getName().equals("descriptor")) continue;
            Descriptor desc = new Descriptor(child);
            desc.renderForC(outStream);
        }
    }

    public void renderForBin(OutputStream outStream) {
        Attribute typeAttr = this.rootNode.getAttribute("type");
        if (typeAttr == null) {
            return;
        }
        this.updateTotalLength();
        for (Element child : this.rootNode.getChildren()) {
            if (child.getName().equals("field")) {
                Element valueNode;
                String substKey;
                String substVal;
                Attribute typeSubst = child.getAttribute("type");
                if (typeSubst != null && typeSubst.getValue().equals("subst") && (substVal = usbNameMap.get(substKey = (valueNode = child.getChild("value")).getValue())) != null) {
                    valueNode.setText(substVal);
                    child.setAttribute("type", "hex");
                    child.setAttribute("order", "le");
                    Element commentNode = child.getChild("comment");
                    if (commentNode == null) {
                        commentNode = new Element("comment");
                        commentNode.setText(substKey);
                        child.addContent(0, (Content)commentNode);
                    }
                }
                Field field = new Field(child);
                field.renderForBin(outStream);
                continue;
            }
            if (!child.getName().equals("descriptor")) continue;
            Descriptor desc = new Descriptor(child);
            desc.renderForBin(outStream);
        }
    }

    public int length() {
        int ret = 0;
        for (Element child : this.rootNode.getChildren()) {
            if (child.getName().equals("field")) {
                Field field = new Field(child);
                ret += field.length();
            }
            if (!child.getName().equals("descriptor")) continue;
            Descriptor desc = new Descriptor(child);
            ret += desc.length();
        }
        return ret;
    }

    public static void main(String[] args) throws JDOMException, IOException {
        System.out.println("Hello, world");
        System.out.println("args.length = " + args.length);
        if (args.length != 1) {
            System.out.println("unexpected command line arguments");
            System.exit(1);
        }
        File xmlFile = new File(args[0]);
        SAXBuilder jdomBuilder = new SAXBuilder();
        Document jdomDocument = jdomBuilder.build(xmlFile);
        Element rootNode = jdomDocument.getRootElement();
        System.out.println(rootNode.getName());
        ElementFilter filter = new ElementFilter("descriptor");
        Element descriptorNode = (Element)rootNode.getDescendants((Filter)filter).next();
        Descriptor descriptor = new Descriptor(descriptorNode);
        descriptor.renderForC(System.out);
    }
}

