/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyUSBLanguageCode
extends Property {
    public PropertyUSBLanguageCode(Device device) {
        super(device, null, "USB Language Code (hex)", null);
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            Long longValue = Long.parseLong(value, 16);
            if (longValue <= 65535L) {
                super.setValue(String.format("%04X", longValue));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "0409";
    }

    @Override
    public String getXMLValue() {
        String xmlValueString = "  <field name=\"usbLanguageCode\" size=\"2\" type=\"hex\">\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <value>";
        xmlValueString = String.valueOf(xmlValueString) + "0x" + this.getValue();
        xmlValueString = String.valueOf(xmlValueString) + "</value>\n";
        xmlValueString = String.valueOf(xmlValueString) + "  </field>";
        return xmlValueString;
    }
}

