/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyPID
extends Property {
    public PropertyPID(Device device) {
        super(device, null, "PID (hex)", null);
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            Integer intValue = Integer.parseInt(value, 16);
            if (intValue <= 65535) {
                super.setValue(String.format("%04X", intValue));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "EAC0";
    }

    @Override
    public String getXMLValue() {
        return this.getValue();
    }
}

