/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyAuthChipAddress
extends Property {
    public PropertyAuthChipAddress(Device device) {
        super(device, null, "Auth Chip Address (hex)", new Item[]{new Item("0", String.format("20", new Object[0])), new Item("1", String.format("22", new Object[0]))});
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            super.setValue(value);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "0";
    }

    @Override
    public String getXMLValue() {
        String xmlValueString = "  <field name=\"authChipAddress\" size=\"1\" type=\"hex\">\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <comment>Default for CP2614 is 0x20</comment>\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <value>";
        xmlValueString = String.valueOf(xmlValueString) + "0x" + this.getValueString();
        xmlValueString = String.valueOf(xmlValueString) + "</value>\n";
        xmlValueString = String.valueOf(xmlValueString) + "  </field>";
        return xmlValueString;
    }
}

