/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.cp261x.CP2614ConfigLibrary;
import com.silabs.customizer.devices.cp261x.Device261x;
import com.silabs.customizer.devices.cp261x.XMLtoHEX.CPConfigurator;
import com.silabs.customizer.log.MessageLog;
import java.io.FileWriter;
import java.io.IOException;

final class Device2614
extends Device261x {
    CP2614ConfigLibrary configLibrary;

    Device2614(String serial) {
        super(serial);
        this.setOTP(false);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(false);
        this.configLibrary = new CP2614ConfigLibrary(this);
    }

    @Override
    public String getType() {
        return "CP2614";
    }

    @Override
    protected synchronized Property[] createIds() {
        Property[] result = this.configLibrary.getIdProperties();
        return result;
    }

    @Override
    public void program() {
        DeviceDetector.getDefault().stop();
        try {
            MessageLog log = new MessageLog();
            log.logInfo("CP261x Device programming generating programming options...");
            String xmlString = this.configLibrary.constructXMLFile();
            try {
                FileWriter write = new FileWriter("c:\\users\\pfick\\desktop\\test.xml", false);
                write.write(xmlString);
                write.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CPConfigurator.generateHexString(xmlString);
            log.logInfo("CP261x Device programming started...");
            log.logInfo("Device programming completed.");
            log.dispose();
        }
        finally {
            DeviceDetector.getDefault().start();
        }
    }

    @Override
    public void resetDevice() throws Exception {
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
    }
}

