/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.cp2112.SLABHIDtoSMBus;
import com.silabs.customizer.devices.cp261x.Device2614;
import com.silabs.customizer.devices.cp261x.PropertyAccessoryHWVersion;
import com.silabs.customizer.devices.cp261x.PropertyAccessoryModelName;
import com.silabs.customizer.devices.cp261x.PropertyActiveChargeEnable;
import com.silabs.customizer.devices.cp261x.PropertyActiveSupplyValue;
import com.silabs.customizer.devices.cp261x.PropertyAppLaunchBundleID;
import com.silabs.customizer.devices.cp261x.PropertyAppLaunchEnable;
import com.silabs.customizer.devices.cp261x.PropertyAudioInOutMode;
import com.silabs.customizer.devices.cp261x.PropertyAuthChipAddress;
import com.silabs.customizer.devices.cp261x.PropertyCLKOUTEnable;
import com.silabs.customizer.devices.cp261x.PropertyCLKOUTFrequency;
import com.silabs.customizer.devices.cp261x.PropertyDefaultSampleRate;
import com.silabs.customizer.devices.cp261x.PropertyEAIOProtocolEnable;
import com.silabs.customizer.devices.cp261x.PropertyEAIOProtocolString;
import com.silabs.customizer.devices.cp261x.PropertyEASerialProtocolEnable;
import com.silabs.customizer.devices.cp261x.PropertyEASerialProtocolString;
import com.silabs.customizer.devices.cp261x.PropertyGPIOAlternateFunction;
import com.silabs.customizer.devices.cp261x.PropertyGPIOMappable;
import com.silabs.customizer.devices.cp261x.PropertyGPIONonMappable;
import com.silabs.customizer.devices.cp261x.PropertyGPIOResetValue;
import com.silabs.customizer.devices.cp261x.PropertyHIDEnable;
import com.silabs.customizer.devices.cp261x.PropertyInactiveChargeEnable;
import com.silabs.customizer.devices.cp261x.PropertyInactiveSupplyValue;
import com.silabs.customizer.devices.cp261x.PropertyMFiDefaultLanguage;
import com.silabs.customizer.devices.cp261x.PropertyManufacturer;
import com.silabs.customizer.devices.cp261x.PropertyNowPlayingEnable;
import com.silabs.customizer.devices.cp261x.PropertyOptionID;
import com.silabs.customizer.devices.cp261x.PropertyPID;
import com.silabs.customizer.devices.cp261x.PropertyPower;
import com.silabs.customizer.devices.cp261x.PropertyPowerMode;
import com.silabs.customizer.devices.cp261x.PropertyProductDescr;
import com.silabs.customizer.devices.cp261x.PropertySerialDataRate;
import com.silabs.customizer.devices.cp261x.PropertyUSBLanguageCode;
import com.silabs.customizer.devices.cp261x.PropertyUseCustomSerial;
import com.silabs.customizer.devices.cp261x.PropertyUseSerialDataRate;
import com.silabs.customizer.devices.cp261x.PropertyVID;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CP2614ConfigLibrary {
    static final int CP2614_SMBUS_VID = 4292;
    static final int CP2614_SMBUS_PID = 60048;
    static final int CP261x_SUCCESS = 0;
    static final int CP261x_ERROR = 255;
    static final int CP2614_SERIAL_STRLEN = 34;
    Device2614 parent = null;
    String xmlTemplateString;
    Map<String, Property> propMap = new HashMap<String, Property>();
    private Property[] idProperties = null;

    static int CP261x_GetNumDevices(IntByReference numDevices) {
        int status = SLABHIDtoSMBus.DLL.HidSmbus_GetNumDevices(numDevices, 4292, 60048);
        if (status != 0) {
            numDevices.setValue(0);
            return 255;
        }
        return 0;
    }

    CP2614ConfigLibrary(Device2614 device) {
        this.parent = device;
        this.propMap.put("UseCustomSerial", new PropertyUseCustomSerial(this.parent));
        this.propMap.put("Serial", new PropertySerial(this.parent, 34));
        this.propMap.put("OptionID", new PropertyOptionID(this.parent));
        this.propMap.put("NowPlayingEnable", new PropertyNowPlayingEnable(this.parent));
        this.propMap.put("EASerialProtocolEnable", new PropertyEASerialProtocolEnable(this.parent));
        this.propMap.put("EAIOProtocolEnable", new PropertyEAIOProtocolEnable(this.parent));
        this.propMap.put("AppLaunchEnable", new PropertyAppLaunchEnable(this.parent));
        this.propMap.put("AppLaunchBundleID", new PropertyAppLaunchBundleID(this.parent));
        this.propMap.put("UseSerialDataRate", new PropertyUseSerialDataRate(this.parent));
        this.propMap.put("SerialDataRate", new PropertySerialDataRate(this.parent));
        this.propMap.put("CLKOUTEnable", new PropertyCLKOUTEnable(this.parent));
        this.propMap.put("CLKOUTFrequency", new PropertyCLKOUTFrequency(this.parent));
        this.propMap.put("AuthChipAddress", new PropertyAuthChipAddress(this.parent));
        this.propMap.put("MFiDefaultLanguage", new PropertyMFiDefaultLanguage(this.parent));
        this.propMap.put("USBLanguageCode", new PropertyUSBLanguageCode(this.parent));
        this.propMap.put("DefaultSampleRate", new PropertyDefaultSampleRate(this.parent));
        this.propMap.put("PowerMode", new PropertyPowerMode(this.parent));
        this.propMap.put("MaxPower", new PropertyPower(this.parent));
        this.propMap.put("ActiveSupplyValue", new PropertyActiveSupplyValue(this.parent));
        this.propMap.put("InactiveSupplyValue", new PropertyInactiveSupplyValue(this.parent));
        this.propMap.put("ActiveCanCharge", new PropertyActiveChargeEnable(this.parent));
        this.propMap.put("InactiveCanCharge", new PropertyInactiveChargeEnable(this.parent));
        this.propMap.put("VID", new PropertyVID(this.parent));
        this.propMap.put("PID", new PropertyPID(this.parent));
        this.propMap.put("ManufacturerString", new PropertyManufacturer(this.parent));
        this.propMap.put("ProductString", new PropertyProductDescr(this.parent));
        this.propMap.put("AccessoryModelName", new PropertyAccessoryModelName(this.parent));
        this.propMap.put("EASerialProtocolString", new PropertyEASerialProtocolString(this.parent));
        this.propMap.put("AccessoryHWVersion", new PropertyAccessoryHWVersion(this.parent));
        this.propMap.put("EAIOProtocolString", new PropertyEAIOProtocolString(this.parent));
        this.propMap.put("AudioInOutMode", new PropertyAudioInOutMode(this.parent));
        this.propMap.put("HIDEnable", new PropertyHIDEnable(this.parent));
        this.propMap.put("GPIO0", new PropertyGPIOMappable(this.parent, "GPIO.0 Mode"));
        this.propMap.put("GPIO1", new PropertyGPIOMappable(this.parent, "GPIO.1 Mode"));
        this.propMap.put("GPIO2", new PropertyGPIOMappable(this.parent, "GPIO.2 Mode"));
        this.propMap.put("GPIO3", new PropertyGPIOMappable(this.parent, "GPIO.3 Mode"));
        this.propMap.put("GPIO4", new PropertyGPIOMappable(this.parent, "GPIO.4 Mode"));
        this.propMap.put("GPIO5", new PropertyGPIOMappable(this.parent, "GPIO.5 Mode"));
        this.propMap.put("GPIO6", new PropertyGPIOMappable(this.parent, "GPIO.6 Mode"));
        this.propMap.put("GPIO7", new PropertyGPIOMappable(this.parent, "GPIO.7 Mode"));
        this.propMap.put("GPIO0AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.0 Alt Func"));
        this.propMap.put("GPIO1AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.1 Alt Func"));
        this.propMap.put("GPIO2AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.2 Alt Func"));
        this.propMap.put("GPIO3AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.3 Alt Func"));
        this.propMap.put("GPIO4AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.4 Alt Func"));
        this.propMap.put("GPIO5AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.5 Alt Func"));
        this.propMap.put("GPIO6AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.6 Alt Func"));
        this.propMap.put("GPIO7AF", new PropertyGPIOAlternateFunction(this.parent, "GPIO.7 Alt Func"));
        this.propMap.put("GPIO0RV", new PropertyGPIOResetValue(this.parent, "GPIO.0 Reset Value"));
        this.propMap.put("GPIO1RV", new PropertyGPIOResetValue(this.parent, "GPIO.1 Reset Value"));
        this.propMap.put("GPIO2RV", new PropertyGPIOResetValue(this.parent, "GPIO.2 Reset Value"));
        this.propMap.put("GPIO3RV", new PropertyGPIOResetValue(this.parent, "GPIO.3 Reset Value"));
        this.propMap.put("GPIO4RV", new PropertyGPIOResetValue(this.parent, "GPIO.4 Reset Value"));
        this.propMap.put("GPIO5RV", new PropertyGPIOResetValue(this.parent, "GPIO.5 Reset Value"));
        this.propMap.put("GPIO6RV", new PropertyGPIOResetValue(this.parent, "GPIO.6 Reset Value"));
        this.propMap.put("GPIO7RV", new PropertyGPIOResetValue(this.parent, "GPIO.7 Reset Value"));
        this.propMap.put("GPIO8", new PropertyGPIONonMappable(this.parent, "GPIO.8 Mode + Alt Func", "VBUS_SENSE/ADC"));
        this.propMap.put("GPIO9", new PropertyGPIONonMappable(this.parent, "GPIO.9 Mode + Alt Func", "BUTTONS"));
        this.propMap.put("GPIO10", new PropertyGPIONonMappable(this.parent, "GPIO.10 Mode + Alt Func", "nRESETOUT"));
        this.propMap.put("GPIO11", new PropertyGPIONonMappable(this.parent, "GPIO.11 Mode + Alt Func", "RTS"));
        this.propMap.put("GPIO12", new PropertyGPIONonMappable(this.parent, "GPIO.12 Mode + Alt Func", "CLKOUT"));
        this.propMap.put("GPIO13", new PropertyGPIONonMappable(this.parent, "GPIO.13 Mode + Alt Func", "TX"));
        this.propMap.put("GPIO14", new PropertyGPIONonMappable(this.parent, "GPIO.14 Mode + Alt Func", "RX"));
        this.propMap.put("GPIO15", new PropertyGPIONonMappable(this.parent, "GPIO.15 Mode + Alt Func", "CTS"));
        this.propMap.put("GPIO8RV", new PropertyGPIOResetValue(this.parent, "GPIO.8 Reset Value"));
        this.propMap.put("GPIO9RV", new PropertyGPIOResetValue(this.parent, "GPIO.9 Reset Value"));
        this.propMap.put("GPIO10RV", new PropertyGPIOResetValue(this.parent, "GPIO.10 Reset Value"));
        this.propMap.put("GPIO11RV", new PropertyGPIOResetValue(this.parent, "GPIO.11 Reset Value"));
        this.propMap.put("GPIO12RV", new PropertyGPIOResetValue(this.parent, "GPIO.12 Reset Value"));
        this.propMap.put("GPIO13RV", new PropertyGPIOResetValue(this.parent, "GPIO.13 Reset Value"));
        this.propMap.put("GPIO14RV", new PropertyGPIOResetValue(this.parent, "GPIO.14 Reset Value"));
        this.propMap.put("GPIO15RV", new PropertyGPIOResetValue(this.parent, "GPIO.15 Reset Value"));
        this.idProperties = new Property[]{this.propMap.get("VID"), this.propMap.get("PID"), this.propMap.get("UseCustomSerial"), this.propMap.get("Serial"), this.propMap.get("ManufacturerString"), this.propMap.get("ProductString"), this.propMap.get("MaxPower"), this.propMap.get("PowerMode"), this.propMap.get("USBLanguageCode"), this.propMap.get("MFiDefaultLanguage"), this.propMap.get("OptionID"), this.propMap.get("AccessoryModelName"), this.propMap.get("AccessoryHWVersion"), this.propMap.get("AudioInOutMode"), this.propMap.get("HIDEnable"), this.propMap.get("EASerialProtocolEnable"), this.propMap.get("EASerialProtocolString"), this.propMap.get("UseSerialDataRate"), this.propMap.get("SerialDataRate"), this.propMap.get("EAIOProtocolEnable"), this.propMap.get("EAIOProtocolString"), this.propMap.get("NowPlayingEnable"), this.propMap.get("AppLaunchEnable"), this.propMap.get("AppLaunchBundleID"), this.propMap.get("CLKOUTEnable"), this.propMap.get("CLKOUTFrequency"), this.propMap.get("AuthChipAddress"), this.propMap.get("DefaultSampleRate"), this.propMap.get("ActiveSupplyValue"), this.propMap.get("InactiveSupplyValue"), this.propMap.get("ActiveCanCharge"), this.propMap.get("InactiveCanCharge"), this.propMap.get("GPIO0"), this.propMap.get("GPIO0AF"), this.propMap.get("GPIO0RV"), this.propMap.get("GPIO1"), this.propMap.get("GPIO1AF"), this.propMap.get("GPIO1RV"), this.propMap.get("GPIO2"), this.propMap.get("GPIO2AF"), this.propMap.get("GPIO2RV"), this.propMap.get("GPIO3"), this.propMap.get("GPIO3AF"), this.propMap.get("GPIO3RV"), this.propMap.get("GPIO4"), this.propMap.get("GPIO4AF"), this.propMap.get("GPIO4RV"), this.propMap.get("GPIO5"), this.propMap.get("GPIO5AF"), this.propMap.get("GPIO5RV"), this.propMap.get("GPIO6"), this.propMap.get("GPIO6AF"), this.propMap.get("GPIO6RV"), this.propMap.get("GPIO7"), this.propMap.get("GPIO7AF"), this.propMap.get("GPIO7RV"), this.propMap.get("GPIO8"), this.propMap.get("GPIO8RV"), this.propMap.get("GPIO9"), this.propMap.get("GPIO9RV"), this.propMap.get("GPIO10"), this.propMap.get("GPIO10RV"), this.propMap.get("GPIO11"), this.propMap.get("GPIO11RV"), this.propMap.get("GPIO12"), this.propMap.get("GPIO12RV"), this.propMap.get("GPIO13"), this.propMap.get("GPIO13RV"), this.propMap.get("GPIO14"), this.propMap.get("GPIO14RV"), this.propMap.get("GPIO15"), this.propMap.get("GPIO15RV")};
        BufferedReader br = null;
        try {
            try {
                Bundle bundle = Platform.getBundle((String)"com.silabs.customizer");
                URL templateFileLocation = bundle.getResource("src/com/silabs/customizer/devices/cp261x/template.xml");
                File templateFile = new File(FileLocator.resolve((URL)templateFileLocation).toURI());
                br = new BufferedReader(new FileReader(templateFile));
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
                this.xmlTemplateString = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    Property[] getIdProperties() {
        return this.idProperties;
    }

    String constructXMLFile() {
        String xmlString = null;
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("serialXML", this.getSerialXMLValue());
        valuesMap.put("optionIDXML", this.propMap.get("OptionID").getXMLValue());
        valuesMap.put("mfiFeaturesFlagXML", this.getMFiFeaturesFlagXMLValue());
        valuesMap.put("nowPlayingMessagesSentXML", ((PropertyNowPlayingEnable)this.propMap.get("NowPlayingEnable")).getMessagesSentXML());
        valuesMap.put("nowPlayingMessagesReceivedXML", ((PropertyNowPlayingEnable)this.propMap.get("NowPlayingEnable")).getMessagesReceivedXML());
        valuesMap.put("eaioProtocolMessagesReceivedXML", ((PropertyEAIOProtocolEnable)this.propMap.get("EAIOProtocolEnable")).getMessagesReceivedXML());
        valuesMap.put("serialDataRateXML", this.getSerialDataRateXMLValue());
        valuesMap.put("clkoutFrequencyXML", this.getCLKOUTFrequencyXMLValue());
        valuesMap.put("appLaunchBundleIDXML", this.propMap.get("AppLaunchBundleID").getXMLValue());
        valuesMap.put("authChipAddressXML", this.propMap.get("AuthChipAddress").getXMLValue());
        valuesMap.put("langParam", this.propMap.get("MFiDefaultLanguage").getXMLValue());
        valuesMap.put("usbLanguageCodeXML", this.propMap.get("USBLanguageCode").getXMLValue());
        valuesMap.put("defaultSampleRateXML", this.propMap.get("DefaultSampleRate").getXMLValue());
        valuesMap.put("powerMode", this.propMap.get("PowerMode").getXMLValue());
        valuesMap.put("activeSupplyValue", this.propMap.get("ActiveSupplyValue").getXMLValue());
        valuesMap.put("inactiveSupplyValue", this.propMap.get("InactiveSupplyValue").getXMLValue());
        valuesMap.put("activeCanCharge", this.propMap.get("ActiveCanCharge").getXMLValue());
        valuesMap.put("inactiveCanCharge", this.propMap.get("InactiveCanCharge").getXMLValue());
        valuesMap.put("vid", this.propMap.get("VID").getXMLValue());
        valuesMap.put("pid", this.propMap.get("PID").getXMLValue());
        valuesMap.put("manufacturer", this.propMap.get("ManufacturerString").getXMLValue());
        valuesMap.put("product", this.propMap.get("ProductString").getXMLValue());
        valuesMap.put("accessoryModelName", this.propMap.get("AccessoryModelName").getXMLValue());
        valuesMap.put("serialProtocolString", this.propMap.get("EASerialProtocolString").getXMLValue());
        valuesMap.put("accessoryHWVersion", this.propMap.get("AccessoryHWVersion").getXMLValue());
        valuesMap.put("maxPower", this.propMap.get("MaxPower").getXMLValue());
        valuesMap.put("convertedMaxPower", this.getConvertedMaxPower(this.propMap.get("MaxPower").getXMLValue()));
        valuesMap.put("eaIoProtocolXML", ((PropertyEAIOProtocolEnable)this.propMap.get("EAIOProtocolEnable")).getEaIoProtocolXML(this.propMap.get("EAIOProtocolString").getXMLValue()));
        valuesMap.put("convertedPowerMode", this.getConvertedPowerMode(this.propMap.get("PowerMode").getXMLValue()));
        valuesMap.put("outStreamDescXML", ((PropertyAudioInOutMode)this.propMap.get("AudioInOutMode")).getOutStreamXML());
        valuesMap.put("inStreamDescXML", ((PropertyAudioInOutMode)this.propMap.get("AudioInOutMode")).getInStreamXML());
        valuesMap.put("outInterfaceDescXML", ((PropertyAudioInOutMode)this.propMap.get("AudioInOutMode")).getOutInterfaceXML());
        valuesMap.put("inInterfaceDescXML", ((PropertyAudioInOutMode)this.propMap.get("AudioInOutMode")).getInInterfaceXML());
        valuesMap.put("appLaunchXML", ((PropertyAppLaunchEnable)this.propMap.get("AppLaunchEnable")).getAppLaunchXml());
        valuesMap.put("serialInterfaceDescXML", ((PropertyEASerialProtocolEnable)this.propMap.get("EASerialProtocolEnable")).getSerialInterfaceXML());
        valuesMap.put("eaSerialProtocolXML", ((PropertyEASerialProtocolEnable)this.propMap.get("EASerialProtocolEnable")).getEaSerialProtocolXML(this.propMap.get("EASerialProtocolString").getXMLValue()));
        valuesMap.put("numInterfaces", this.getInterfaceCount());
        valuesMap.put("numAudioInterfaces", String.format("%d", ((PropertyAudioInOutMode)this.propMap.get("AudioInOutMode")).getInterfaceCount()));
        valuesMap.put("hidMessagesSentXML", ((PropertyHIDEnable)this.propMap.get("HIDEnable")).getMessagesSentXML());
        valuesMap.put("hidMessagesReceivedXML", ((PropertyHIDEnable)this.propMap.get("HIDEnable")).getMessagesReceivedXML());
        valuesMap.put("hidProtocolXML", ((PropertyHIDEnable)this.propMap.get("HIDEnable")).getHIDProtocolXML());
        valuesMap.put("gpioAltFunc", this.getGPIOAltFuncMask());
        valuesMap.put("gpioDirection", this.getGPIODirectionMask());
        valuesMap.put("gpioMode", this.getGPIOModeMask());
        valuesMap.put("gpioInit", this.getGPIOInitValueMask());
        try {
            StrSubstitutor ss = new StrSubstitutor(valuesMap);
            xmlString = ss.replace(this.xmlTemplateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    private String getSerialDataRateXMLValue() {
        if (this.propMap.get("UseSerialDataRate").getValue() == "0") {
            return this.propMap.get("UseSerialDataRate").getXMLValue();
        }
        return this.propMap.get("SerialDataRate").getXMLValue();
    }

    private String getSerialXMLValue() {
        if (this.propMap.get("UseCustomSerial").getValue() == "0") {
            return this.propMap.get("UseCustomSerial").getXMLValue();
        }
        return this.propMap.get("Serial").getXMLValue();
    }

    private String getCLKOUTFrequencyXMLValue() {
        if (this.propMap.get("CLKOUTEnable").getValue() == "0") {
            return this.propMap.get("CLKOUTEnable").getXMLValue();
        }
        return this.propMap.get("CLKOUTFrequency").getXMLValue();
    }

    private void appendBitMaskInfo(String propertyName, MutableInt bitMaskValue, StringBuilder bitMaskString) {
        bitMaskValue.setValue(this.propMap.get(propertyName).getBitMaskValue() | bitMaskValue.getValue());
        if (this.propMap.get(propertyName).getBitMaskValue() != 0) {
            bitMaskString.append(String.valueOf(this.propMap.get(propertyName).getBitMaskString()) + " | ");
        }
    }

    private String getMFiFeaturesFlagXMLValue() {
        MutableInt bitMaskValue = new MutableInt(0);
        StringBuilder bitMaskString = new StringBuilder(" ");
        this.appendBitMaskInfo("NowPlayingEnable", bitMaskValue, bitMaskString);
        this.appendBitMaskInfo("EASerialProtocolEnable", bitMaskValue, bitMaskString);
        this.appendBitMaskInfo("EAIOProtocolEnable", bitMaskValue, bitMaskString);
        this.appendBitMaskInfo("AppLaunchEnable", bitMaskValue, bitMaskString);
        String xmlString = "  <field name=\"mfiFeatureFlags\" size=\"1\">\n";
        xmlString = String.valueOf(xmlString) + "    <comment>";
        xmlString = String.valueOf(xmlString) + bitMaskString;
        xmlString = String.valueOf(xmlString) + "</comment>\n";
        xmlString = String.valueOf(xmlString) + "    <value>";
        xmlString = String.valueOf(xmlString) + String.format("0x%02X", bitMaskValue.getValue());
        xmlString = String.valueOf(xmlString) + "</value>\n";
        xmlString = String.valueOf(xmlString) + "  </field>";
        return xmlString;
    }

    private String getConvertedMaxPower(String maxPowerValue) {
        Integer intValue = Integer.parseInt(maxPowerValue, 10);
        intValue = intValue >> 1;
        return String.format("%d", intValue);
    }

    private String getConvertedPowerMode(String powerMode) {
        if (powerMode == "0") {
            return "0xC0";
        }
        return "0x80";
    }

    private String getInterfaceCount() {
        int interfaceCount = 1;
        ++interfaceCount;
        return String.format("%d", interfaceCount += ((PropertyAudioInOutMode)this.propMap.get("AudioInOutMode")).getInterfaceCount());
    }

    private String getGPIOAltFuncMask() {
        int mask = 0;
        int i = 0;
        while (i < 8) {
            mask |= Integer.parseInt(((PropertyGPIOAlternateFunction)this.propMap.get("GPIO" + String.format("%d", i) + "AF")).getValue()) << i;
            ++i;
        }
        i = 8;
        while (i < 16) {
            mask |= Integer.parseInt(((PropertyGPIONonMappable)this.propMap.get("GPIO" + String.format("%d", i))).getAltFuncValue()) << i;
            ++i;
        }
        return String.format("%04X", mask);
    }

    private String getGPIODirectionMask() {
        int mask = 0;
        int i = 0;
        while (i < 8) {
            mask |= Integer.parseInt(((PropertyGPIOMappable)this.propMap.get("GPIO" + String.format("%d", i))).getDirValue()) << i;
            ++i;
        }
        i = 8;
        while (i < 16) {
            mask |= Integer.parseInt(((PropertyGPIONonMappable)this.propMap.get("GPIO" + String.format("%d", i))).getModeValue()) << i;
            ++i;
        }
        return String.format("%04X", mask);
    }

    private String getGPIOModeMask() {
        int mask = 0;
        int i = 0;
        while (i < 8) {
            mask |= Integer.parseInt(((PropertyGPIOMappable)this.propMap.get("GPIO" + String.format("%d", i))).getDirValue()) << i;
            ++i;
        }
        i = 8;
        while (i < 16) {
            mask |= Integer.parseInt(((PropertyGPIONonMappable)this.propMap.get("GPIO" + String.format("%d", i))).getModeValue()) << i;
            ++i;
        }
        return String.format("%04X", mask);
    }

    private String getGPIOInitValueMask() {
        int mask = 0;
        int i = 0;
        while (i < 16) {
            mask |= Integer.parseInt(((PropertyGPIOResetValue)this.propMap.get("GPIO" + String.format("%d", i) + "RV")).getValue()) << i;
            ++i;
        }
        return String.format("%04X", mask);
    }
}

