/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp213x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyManufacturer;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerModeWithVReg;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyTransferPriority;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp213x.CP2130GroupPortConfigRoot;
import com.silabs.customizer.devices.cp213x.CP2130PinConfig;
import com.silabs.customizer.devices.cp213x.Device213x;
import com.silabs.customizer.devices.cp213x.SLAB_USB_SPI;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ShortByReference;

final class Device2130
extends Device213x {
    Device2130(String serial) {
        super(serial);
        this.setOTP(true);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2130";
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerModeWithVReg(this), new PropertyReleaseVer(this), new PropertyManufacturer(this), new PropertyProductDescr(this), new PropertySerial(this, 30), new PropertyTransferPriority(this), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2130PinConfig writeConfig) throws Exception {
        Device2130.checkDeviceDetection();
        if (writeConfig.pinConfigs.length != 11) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2130.openDevice((Device213x)deviceObj);
        int status = SLAB_USB_SPI.DLL.CP213x_SetPinConfig(device, writeConfig.getConfigBuffer());
        Device2130.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized CP2130PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2130.checkDeviceDetection();
        Pointer device = Device2130.openDevice((Device213x)deviceObj);
        byte[] pinConfigBuffer = new byte[20];
        int status = SLAB_USB_SPI.DLL.CP213x_GetPinConfig(device, pinConfigBuffer);
        Device2130.close(device);
        CP2130PinConfig result = new CP2130PinConfig(pinConfigBuffer);
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2130GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2130.checkDeviceDetection();
        Pointer device = Device2130.openDevice((Device213x)deviceObj);
        ShortByReference lockValue = new ShortByReference();
        int status = SLAB_USB_SPI.DLL.CP213x_GetLock(device, lockValue);
        Device2130.close(device);
        String result = "00";
        if (lockValue.getValue() == 0) {
            result = "01";
        }
        LOG.logDebug(status, "getLockValue:", result);
        if (status != 0) {
            throw new Exception("getLockValue(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2130.checkDeviceDetection();
        Pointer device = Device2130.openDevice((Device213x)deviceObj);
        short lockValue = 0;
        int status = SLAB_USB_SPI.DLL.CP213x_SetLock(device, lockValue);
        Device2130.close(device);
        LOG.logDebug(status, "setLockValue:", value);
        if (status != 0) {
            throw new Exception("setLockValue(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EA80");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0100");
        idProps[5].reset("05");
        idProps[6].reset("Silicon Laboratories");
        idProps[7].reset("CP2130 HID USB-to-SPI Bridge");
        idProps[9].reset("01");
        idProps[10].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2130GroupPortConfigRoot cp2130PortConfigRoot = (CP2130GroupPortConfigRoot)portConfigProps[0];
        cp2130PortConfigRoot.resetSiliconLabsDefaultValues();
    }
}

