/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyFlushBuffers;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyManufacturer;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerModeWithVReg;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp211x.CP2114GroupPortConfigRoot;
import com.silabs.customizer.devices.cp211x.CP2114PinConfig;
import com.silabs.customizer.devices.cp211x.Device211x;
import com.silabs.customizer.devices.cp211x.SLABHIDtoUART;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;

public final class Device2114
extends Device211x {
    protected int firmwareVersion;
    protected int apiVersion;

    Device2114(String serial) {
        super(serial);
        this.setOTP(true);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2114";
    }

    public int getFwVersion() {
        return this.firmwareVersion;
    }

    public void setVersions(DeviceVersions vers) {
        if (this.firmwareVersion == 0) {
            this.setName(String.valueOf(this.getName()) + " (ver=" + String.format("0x%02X", vers.firmwareVersion) + ")");
        }
        this.firmwareVersion = vers.firmwareVersion;
        this.apiVersion = vers.apiVersion;
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerModeWithVReg(this), new PropertyReleaseVer(this), new PropertyFlushBuffers(this, 1), new PropertyManufacturer(this), new PropertyProductDescr(this), new PropertySerial(this, 30), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2114PinConfig writeConfig) throws Exception {
        Device2114.checkDeviceDetection();
        if (writeConfig.pinConfigs.length != 14) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2114.openDevice((Device211x)deviceObj);
        int status = SLABHIDtoUART.DLL.CP2114_SetPinConfig(device, writeConfig.pinConfigs, writeConfig.useSupendValues(), writeConfig.suspendValue, writeConfig.suspendMode, writeConfig.clkDiv);
        Device2114.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    public static synchronized CP2114PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice((Device211x)deviceObj);
        byte[] pinConfig = new byte[14];
        IntByReference useSuspendValues = new IntByReference();
        IntByReference suspendValue = new IntByReference();
        IntByReference suspendMode = new IntByReference();
        ShortByReference clkDiv = new ShortByReference();
        int status = SLABHIDtoUART.DLL.CP2114_GetPinConfig(device, pinConfig, useSuspendValues, suspendValue, suspendMode, clkDiv);
        Device2114.close(device);
        CP2114PinConfig result = new CP2114PinConfig(pinConfig, useSuspendValues.getValue(), suspendValue.getValue(), suspendMode.getValue(), clkDiv.getValue());
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    public static synchronized DeviceVersions getVersions(Device deviceObj) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice((Device211x)deviceObj);
        byte[] apiVersion = new byte[1];
        byte[] fwVersion = new byte[1];
        byte[] cfgVersion = new byte[1];
        int status = SLABHIDtoUART.DLL.CP2114_GetVersions(device, apiVersion, fwVersion, cfgVersion);
        Device2114.close(device);
        if (status != 0) {
            throw new Exception("getVersions(" + deviceObj + "): " + status);
        }
        DeviceVersions vers = new DeviceVersions();
        vers.apiVersion = apiVersion[0];
        vers.firmwareVersion = fwVersion[0];
        return vers;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2114GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    protected Property[] createBaudConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    public final synchronized void getDeviceCaps(byte[] pCP2114CapsStruct) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_GetDeviceCaps(device, pCP2114CapsStruct);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_GetDeviceCaps", pCP2114CapsStruct);
        if (status != 0) {
            throw new Exception("getDeviceCaps(" + this + "): " + status);
        }
    }

    public final synchronized int setRamConfig(byte[] pCP2114RamConfigStruct) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_SetRamConfig(device, pCP2114RamConfigStruct);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_SetRamConfig", pCP2114RamConfigStruct);
        return status;
    }

    public final synchronized void getRamConfig(byte[] pCP2114RamConfigStruct) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_GetRamConfig(device, pCP2114RamConfigStruct);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_GetRamConfig", pCP2114RamConfigStruct);
        if (status != 0) {
            throw new Exception("getRamConfig(" + this + "): " + status);
        }
    }

    public final synchronized void setDacRegisters(byte[] pDacConfigBuffer, byte dacConfigBufferLength) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_SetDacRegisters(device, pDacConfigBuffer, dacConfigBufferLength);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_SetDacRegisters", pDacConfigBuffer);
        if (status != 0) {
            throw new Exception("setDacRegisters(" + this + "): " + status);
        }
    }

    public final synchronized void getDacRegisters(byte dacStartAddress, byte dacRegistersToRead, byte[] pDacConfigBuffer) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_GetDacRegisters(device, dacStartAddress, dacRegistersToRead, pDacConfigBuffer);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_GetDacRegisters", pDacConfigBuffer);
        if (status != 0) {
            throw new Exception("getDacRegisters(" + this + "): " + status);
        }
    }

    public final synchronized int getOtpConfig(byte cp2114ConfigNumber, byte[] pCP2114ConfigStruct) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_GetOtpConfig(device, cp2114ConfigNumber, pCP2114ConfigStruct);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_GetOtpConfig", cp2114ConfigNumber, pCP2114ConfigStruct);
        return status;
    }

    public final synchronized void createOtpConfig(short configBufferLength, byte[] pConfigBuffer) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_CreateOtpConfig(device, configBufferLength, pConfigBuffer);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_CreateOtpConfig", pConfigBuffer);
        if (status != 0) {
            throw new Exception("createOtpConfig(" + this + "): " + status);
        }
    }

    public final synchronized int setBootConfig(byte cp2114ConfigNumber) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_SetBootConfig(device, cp2114ConfigNumber);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_SetBootConfig");
        return status;
    }

    public final synchronized void readOtp(int cp2114Address, byte[] pReadBuffer, int readLength) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_ReadOTP(device, cp2114Address, pReadBuffer, readLength);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_ReadOTP", cp2114Address, pReadBuffer);
        if (status != 0) {
            throw new Exception("readOtp(" + this + "): " + status);
        }
    }

    public final synchronized void writeOtp(int cp2114Address, byte[] pWriteBuffer, int writeLength) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice(this);
        int status = SLABHIDtoUART.DLL.CP2114_WriteOTP(device, cp2114Address, pWriteBuffer, writeLength);
        Device2114.close(device);
        LOG.logDebug(status, "CP2114_WriteOTP", cp2114Address, pWriteBuffer);
        if (status != 0) {
            throw new Exception("writeOtp(" + this + "): " + status);
        }
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice((Device211x)deviceObj);
        ShortByReference lockValue = new ShortByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetLock(device, lockValue);
        Device2114.close(device);
        String result = "00";
        if (lockValue.getValue() == 0) {
            result = "01";
        }
        LOG.logDebug(status, "getLockValue:", result);
        if (status != 0) {
            throw new Exception("getLockValue(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2114.checkDeviceDetection();
        Pointer device = Device2114.openDevice((Device211x)deviceObj);
        short lockValue = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetLock(device, lockValue);
        Device2114.close(device);
        LOG.logDebug(status, "setLockValue:", value);
        if (status != 0) {
            throw new Exception("setLockValue(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EAB0");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0100");
        idProps[5].reset("05");
        idProps[6].reset("Silicon Laboratories");
        idProps[7].reset("CP2114 USB-Audio Bridge");
        idProps[9].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2114GroupPortConfigRoot cp2114PortConfigRoot = (CP2114GroupPortConfigRoot)portConfigProps[0];
        cp2114PortConfigRoot.resetSiliconLabsDefaultValues();
    }

    public static class DeviceVersions {
        byte apiVersion;
        byte firmwareVersion;
    }
}

