/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class CP2114SuspendValueDialog
extends StatusDialog {
    private Button bit0;
    private Button bit1;
    private Button bit2;
    private Button bit3;
    private Button bit4;
    private Button bit5;
    private Button bit6;
    private Button bit7;
    private Button bit8;
    private Button bit9;
    private Button bit10;
    private Button bit11;
    private Button bit12;
    private Button bit13;
    private Button bit14;
    private Button bit15;
    private Button[] bits;
    private Label lblDescr;
    private String description;
    private Label lblResult;
    private String value;

    CP2114SuspendValueDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        this.setTitle("Suspend Value Settings");
        this.setDescription("Uncheck: Latch = 0 in suspend. Check: Latch = 1 in suspend.");
        this.setValue("0000");
    }

    public String getValue() {
        return this.value;
    }

    public final void setDescription(String description) {
        this.description = description;
        if (this.lblDescr != null) {
            this.lblDescr.setText(description);
        }
    }

    public final void setValue(String hexWord) {
        if (hexWord.length() > 4) {
            throw new NumberFormatException("hexWord: " + String.valueOf(hexWord));
        }
        if (this.bit0 == null) {
            this.value = String.format("%04X", Integer.parseInt(hexWord, 16));
        } else {
            Integer i = Integer.parseInt(hexWord, 16);
            this.bit0.setSelection((i & 1) > 0);
            this.bit1.setSelection((i & 2) > 0);
            this.bit2.setSelection((i & 4) > 0);
            this.bit3.setSelection((i & 8) > 0);
            this.bit4.setSelection((i & 0x10) > 0);
            this.bit5.setSelection((i & 0x20) > 0);
            this.bit6.setSelection((i & 0x40) > 0);
            this.bit7.setSelection((i & 0x80) > 0);
            this.bit8.setSelection((i & 0x100) > 0);
            this.bit10.setSelection((i & 0x400) > 0);
            this.bit11.setSelection((i & 0x800) > 0);
            this.bit12.setSelection((i & 0x1000) > 0);
            this.bit13.setSelection((i & 0x2000) > 0);
            this.bit14.setSelection(false);
            this.bit15.setSelection(false);
            this.value = this.computeValue();
        }
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fontDatas;
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        GridDataFactory gdfFill2 = GridDataFactory.fillDefaults().grab(true, false).span(2, 1);
        this.lblDescr = new Label(result, 64);
        this.lblDescr.setText(String.valueOf(this.description));
        gdfFill2.copy().minSize(250, -1).applyTo((Control)this.lblDescr);
        this.createSpacer(result);
        this.bit0 = this.createButton(result, "GPIO.0 / RMute");
        this.bit8 = this.createButton(result, "GPIO.8 / CTS");
        this.bit1 = this.createButton(result, "GPIO.1 / PMute");
        this.bit9 = this.createButton(result, "GPIO.9 / CLK");
        this.bit2 = this.createButton(result, "GPIO.2 / Down");
        this.bit10 = this.createButton(result, "GPIO.10 / TX");
        this.bit3 = this.createButton(result, "GPIO.3 / Up");
        this.bit11 = this.createButton(result, "GPIO.11 / RX");
        this.bit4 = this.createButton(result, "GPIO.4 / LED 1");
        this.bit12 = this.createButton(result, "Suspend");
        this.bit5 = this.createButton(result, "GPIO.5 / TXT");
        this.bit13 = this.createButton(result, "/Suspend");
        this.bit6 = this.createButton(result, "GPIO.6 / RXT");
        this.bit14 = this.createButton(result, "N/A");
        this.bit14.setEnabled(false);
        this.bit7 = this.createButton(result, "GPIO.7 / RTS");
        this.bit15 = this.createButton(result, "N/A");
        this.bit15.setEnabled(false);
        this.bits = new Button[]{this.bit0, this.bit1, this.bit2, this.bit3, this.bit4, this.bit5, this.bit6, this.bit7, this.bit8, this.bit9, this.bit10, this.bit11, this.bit12, this.bit13, this.bit14, this.bit15};
        result.setTabList((Control[])this.bits);
        this.createSpacer(result);
        this.lblResult = new Label(result, 0);
        this.setValue(this.value);
        this.lblResult.setText("Result (hex): " + this.value);
        gdfFill2.applyTo((Control)this.lblResult);
        FontData[] fontDataArray = fontDatas = this.lblResult.getFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(1);
            ++n2;
        }
        final Font fontBold = new Font((Device)this.lblResult.getDisplay(), fontDatas);
        this.lblResult.setFont(fontBold);
        this.lblResult.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fontBold.dispose();
            }
        });
        this.addListeners();
        return result;
    }

    private void addListeners() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CP2114SuspendValueDialog.this.value = CP2114SuspendValueDialog.this.computeValue();
                CP2114SuspendValueDialog.this.lblResult.setText("Result (hex): " + CP2114SuspendValueDialog.this.value);
            }
        };
        Button[] buttonArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener((SelectionListener)selectionListener);
            ++n2;
        }
    }

    private String computeValue() {
        long value = 0L;
        int i = 0;
        while (i < this.bits.length) {
            value |= (long)((this.bits[i].getSelection() ? 1 : 0) << i);
            ++i;
        }
        String result = String.format("%04X", value);
        return result;
    }

    private Button createButton(Composite parent, String caption) {
        Button result = new Button(parent, 32);
        result.setText(caption);
        return result;
    }

    private void createSpacer(Composite result) {
        Label lblSpacer = new Label(result, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)lblSpacer);
    }
}

