/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.devices.cp210x.CP210xManufacturing;
import com.silabs.customizer.devices.cp210x.Device2101;
import com.silabs.customizer.devices.cp210x.Device2102;
import com.silabs.customizer.devices.cp210x.Device2103;
import com.silabs.customizer.devices.cp210x.Device2104;
import com.silabs.customizer.devices.cp210x.Device2105;
import com.silabs.customizer.devices.cp210x.Device2108;
import com.silabs.customizer.devices.cp210x.Device2109;
import com.silabs.customizer.log.MessageLog;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class Device210x
extends Device {
    public static final MessageLog LOG = new MessageLog();
    private String serial;
    private String deviceString;
    private String name;

    static {
        LOG.logDebug("CP210x Library Version    :", Device210x.getLibraryVersion());
    }

    public static synchronized List<Device> getDevices() {
        Device210x.checkDeviceDetection();
        LinkedList<Device> result = new LinkedList<Device>();
        int numDevices = Device210x.getNumDevices();
        int i = 0;
        while (i < numDevices) {
            try {
                String serial = Device210x.getSerial(i);
                String deviceString = Device210x.getDeviceString(i);
                PartNumber part = Device210x.getPartNumber(i);
                if (part.number == 1) {
                    result.add(new Device2101(serial, deviceString));
                } else if (part.number == 2) {
                    result.add(new Device2102(serial, deviceString));
                } else if (part.number == 3) {
                    result.add(new Device2103(serial, deviceString));
                } else if (part.number == 4) {
                    result.add(new Device2104(serial, deviceString));
                } else if (part.number == 5) {
                    result.add(new Device2105(serial, deviceString));
                } else if (part.number == 8) {
                    result.add(new Device2108(serial, deviceString));
                } else if (part.number == 9) {
                    result.add(new Device2109(serial, deviceString));
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    @Override
    protected Property[] createPortConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    protected Property[] createBaudConfigs() {
        Property[] result = new Property[]{};
        return result;
    }

    @Override
    public final synchronized String getPID(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        IntByReference pid = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDevicePid(device, pid);
        Device210x.close(device);
        String result = status == 0 ? Device210x.toHexString(pid.getValue(), 4) : "";
        LOG.logDebug(status, "getPID:", result);
        if (status != 0) {
            throw new Exception("getPID(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPower(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        ByteByReference power = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetMaxPower(device, power);
        Device210x.close(device);
        String result = status == 0 ? Device210x.toHexString(power.getValue(), 2) : "";
        LOG.logDebug(status, "getPower:", result);
        if (status != 0) {
            throw new Exception("getPower(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getPowerMode(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        ByteByReference powerMode = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetSelfPower(device, powerMode);
        Device210x.close(device);
        String result = status == 0 ? Device210x.toHexString(powerMode.getValue(), 2) : "";
        LOG.logDebug(status, "getPowerMode:", result);
        if (status != 0) {
            throw new Exception("getPowerMode(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getProduct(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        byte[] productString = new byte[this.maxProductStrlen];
        ByteByReference strlen = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceProductString(device, productString, strlen, true);
        Device210x.close(device);
        String result = status == 0 ? Native.toString((byte[])productString) : "";
        LOG.logDebug(status, "getProduct:", result);
        if (status != 0) {
            throw new Exception("getProduct(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getReleaseVersion(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        IntByReference releaseVersion = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceVersion(device, releaseVersion);
        Device210x.close(device);
        String result = "";
        if (status == 0) {
            result = Device210x.toHexString(releaseVersion.getValue(), 4);
        }
        LOG.logDebug(status, "getRelease:", result);
        if (status != 0) {
            throw new Exception("getRelease(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getSerial(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        byte[] serialString = new byte[maxSerialStrlen];
        ByteByReference strlen = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceSerialNumber(device, serialString, strlen, true);
        Device210x.close(device);
        String result = status == 0 ? Native.toString((byte[])serialString) : "";
        LOG.logDebug(status, "getSerial:", result);
        if (status != 0) {
            throw new Exception("getSerial(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized String getVID(Device deviceObj) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        IntByReference vid = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceVid(device, vid);
        Device210x.close(device);
        String result = status == 0 ? Device210x.toHexString(vid.getValue(), 4) : "";
        LOG.logDebug(status, "getVID:", result);
        if (status != 0) {
            throw new Exception("getVID(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public final synchronized void setProduct(Device deviceObj, String product) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        byte[] prodStr = Native.toByteArray((String)product);
        int status = 2;
        if (prodStr.length < 127) {
            byte strlen = (byte)prodStr.length;
            status = CP210xManufacturing.DLL.CP210x_SetProductString(device, prodStr, strlen, true);
        }
        Device210x.close(device);
        LOG.logDebug(status, "setProduct:", Arrays.toString(prodStr));
        if (status != 0) {
            throw new Exception("setProduct(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setSerial(Device deviceObj, String serial) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        byte[] serialStr = Native.toByteArray((String)serial);
        int status = 2;
        if (serialStr.length < 127) {
            byte strlen = (byte)serialStr.length;
            status = CP210xManufacturing.DLL.CP210x_SetSerialNumber(device, serialStr, strlen, true);
        }
        Device210x.close(device);
        LOG.logDebug(status, "setSerial:", Arrays.toString(serialStr));
        if (status != 0) {
            throw new Exception("setSerial(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setReleaseVersion(Device deviceObj, String value) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        int releaseVersion = Integer.parseInt(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetDeviceVersion(device, releaseVersion);
        Device210x.close(device);
        LOG.logDebug(status, "setReleaseVersion:", value);
        if (status != 0) {
            throw new Exception("setReleaseVersion(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPID(Device deviceObj, String value) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        int pid = Integer.parseInt(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetPid(device, pid);
        Device210x.close(device);
        LOG.logDebug(status, "setPID:", value);
        if (status != 0) {
            throw new Exception("setPID(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setVID(Device deviceObj, String value) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        int vid = Integer.parseInt(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetVid(device, vid);
        Device210x.close(device);
        LOG.logDebug(status, "setVID:", value);
        if (status != 0) {
            throw new Exception("setVID(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPower(Device deviceObj, String value) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        byte power = Byte.parseByte(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetMaxPower(device, power);
        Device210x.close(device);
        LOG.logDebug(status, "setPower:", value);
        if (status != 0) {
            throw new Exception("setPower(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized void setPowerMode(Device deviceObj, String value) throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice((Device210x)deviceObj);
        boolean powerMode = Byte.parseByte(value, 16) != 0;
        int status = CP210xManufacturing.DLL.CP210x_SetSelfPower(device, powerMode);
        Device210x.close(device);
        LOG.logDebug(status, "setPowerMode:", value);
        if (status != 0) {
            throw new Exception("setPowerMode(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized void checkDeviceDetection() {
        if (!DeviceDetector.getDefault().isStopped()) {
            new IllegalStateException("Device detection still active");
        }
    }

    protected static synchronized void close(Pointer device) {
        if (device != null) {
            CP210xManufacturing.DLL.CP210x_Close(device);
        }
    }

    private static synchronized Object getLibraryVersion() {
        String result = "N/A";
        return result;
    }

    private static synchronized int getNumDevices() {
        IntByReference numDevices = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetNumDevices(numDevices);
        if (status != 0) {
            numDevices.setValue(0);
        }
        return numDevices.getValue();
    }

    private static synchronized PartNumber getPartNumber(int deviceNum) throws Exception {
        Pointer device = Device210x.open(deviceNum);
        IntByReference partNumber = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetPartNumber(device, partNumber);
        Device210x.close(device);
        if (status != 0) {
            throw new Exception("getPartNumber(" + deviceNum + "): " + status);
        }
        return new PartNumber(partNumber.getValue(), 0);
    }

    private static synchronized String getSerial(int deviceNum) throws Exception {
        String result;
        byte[] deviceString = new byte[63];
        int status = CP210xManufacturing.DLL.CP210x_GetProductString(deviceNum, deviceString, 0);
        String string = result = status == 0 ? Native.toString((byte[])deviceString) : "";
        if (status != 0) {
            throw new Exception("getSerial(" + deviceNum + "): " + status);
        }
        return result;
    }

    private static synchronized String getDeviceString(int deviceNum) throws Exception {
        String result;
        byte[] deviceString = new byte[maxDeviceStrlen];
        int status = CP210xManufacturing.DLL.CP210x_GetProductString(deviceNum, deviceString, 2);
        String string = result = status == 0 ? Native.toString((byte[])deviceString) : "";
        if (status != 0) {
            throw new Exception("getDeviceString(" + deviceNum + "): " + status);
        }
        return result;
    }

    private static synchronized Pointer open(int deviceNum) throws Exception {
        PointerByReference devicePtr = new PointerByReference();
        int status = CP210xManufacturing.DLL.CP210x_Open(deviceNum, devicePtr);
        if (status != 0) {
            throw new Exception("open(" + deviceNum + "): " + status);
        }
        return devicePtr.getValue();
    }

    protected static synchronized Pointer openDevice(Device210x device) throws Exception {
        Pointer result = null;
        int numDevices = Device210x.getNumDevices();
        int i = 0;
        while (i < numDevices && result == null) {
            try {
                String deviceString = Device210x.getDeviceString(i);
                if (device.getDeviceString().equals(deviceString)) {
                    result = Device210x.open(i);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (result == null) {
            throw new Exception("Device not found: " + device);
        }
        return result;
    }

    @Override
    public void resetDevice() throws Exception {
        Device210x.checkDeviceDetection();
        Pointer device = Device210x.openDevice(this);
        int status = CP210xManufacturing.DLL.CP210x_Reset(device);
        Device210x.close(device);
        String result = status == 0 || status == 3 ? "Success" : "Failed";
        LOG.logDebug(status, "resetDevice:", result);
        if (status != 0 && status != 3) {
            throw new Exception("resetDevice(" + this + "): " + status);
        }
        DeviceDetector.getDefault().startWaitForReset();
        int timeoutMilliseconds = 20000;
        while (DeviceDetector.getDefault().isWaitingForReset() && timeoutMilliseconds > 0) {
            Thread.sleep(100L);
            DeviceDetector.getDefault().start();
            timeoutMilliseconds -= 100;
        }
        if (DeviceDetector.getDefault().isWaitingForReset()) {
            DeviceDetector.getDefault().cancelWaitForReset();
            throw new Exception("resetDevice(" + this + "): - Device never came back from reset");
        }
    }

    @Override
    public String getManufacturer(Device device) throws Exception {
        return null;
    }

    @Override
    public void setManufacturer(Device device, String value) throws Exception {
    }

    @Override
    public String getInterfaceString(Device device, int interfaceNumber) throws Exception {
        return null;
    }

    @Override
    public void setInterfaceString(Device device, int interfaceNumber, String value) throws Exception {
    }

    @Override
    public String getFlushBuffers(Device device) throws Exception {
        return null;
    }

    @Override
    public void setFlushBuffers(Device device, String value) throws Exception {
    }

    @Override
    public String getDeviceMode(Device device) throws Exception {
        return null;
    }

    @Override
    public void setDeviceMode(Device device, String value) throws Exception {
    }

    @Override
    public void setBaudConfig(Device deviceObj, CP210xBaudConfig writeConfig) throws Exception {
    }

    @Override
    public CP210xBaudConfig getBaudConfig(Device deviceObj) throws Exception {
        return null;
    }

    @Override
    public String getLockValue(Device device) throws Exception {
        return null;
    }

    @Override
    public void setLockValue(Device device, String value) throws Exception {
    }

    @Override
    public String getTransferPriority(Device device) throws Exception {
        return null;
    }

    @Override
    public void setTransferPriority(Device device, String value) throws Exception {
    }

    protected static String toHexString(int value, int digits) {
        String result = String.format("%X", value);
        int diff = digits - result.length();
        while (diff > 0) {
            result = "0" + result;
            --diff;
        }
        return result;
    }

    protected Device210x(String serial, String deviceString) {
        this.setSerial(serial);
        this.setDeviceString(deviceString);
        maxDeviceStrlen = 256;
        this.maxManufacturerStrlen = 45;
        this.maxProductStrlen = 126;
        maxSerialStrlen = 63;
        this.maxInterfaceStrlen = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public void setSerial(String serial) {
        if (serial == null) {
            throw new NullPointerException("serial");
        }
        this.serial = serial;
        this.name = String.valueOf(this.getType()) + " - " + serial;
    }

    @Override
    public String getDeviceString() {
        return this.deviceString;
    }

    public void setDeviceString(String deviceString) {
        if (deviceString == null) {
            throw new NullPointerException("deviceString");
        }
        this.deviceString = deviceString;
    }

    private static final class PartNumber {
        private final int number;
        private final int version;

        public PartNumber(int number, int version) {
            this.number = number;
            this.version = version;
        }
    }
}

