/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerMode;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp210x.CP2103_4GroupPortConfigRoot;
import com.silabs.customizer.devices.cp210x.CP2103_4PinConfig;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.devices.cp210x.CP210xGroupBaudConfigRoot;
import com.silabs.customizer.devices.cp210x.CP210xManufacturing;
import com.silabs.customizer.devices.cp210x.Device210x;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;

final class Device2103
extends Device210x {
    Device2103(String serial, String deviceString) {
        super(serial, deviceString);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(true);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2103";
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerMode(this), new PropertyReleaseVer(this), new PropertyProductDescr(this), new PropertySerial(this, maxSerialStrlen), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2103_4PinConfig writeConfig) throws Exception {
        Device2103.checkDeviceDetection();
        if (writeConfig.pinConfigs.length != 13) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2103.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetPortConfig(device, writeConfig.getConfigStruct());
        Device2103.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized CP2103_4PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2103.checkDeviceDetection();
        Pointer device = Device2103.openDevice((Device210x)deviceObj);
        byte[] portConfig = new byte[7];
        int status = CP210xManufacturing.DLL.CP210x_GetPortConfig(device, portConfig);
        Device2103.close(device);
        CP2103_4PinConfig result = new CP2103_4PinConfig(portConfig);
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2103_4GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public synchronized void setBaudConfig(Device deviceObj, CP210xBaudConfig writeConfig) throws Exception {
        Device2103.checkDeviceDetection();
        if (writeConfig.baudConfigs.length != 32) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2103.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetBaudRateConfig(device, writeConfig.getConfigStruct());
        Device2103.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    @Override
    public CP210xBaudConfig getBaudConfig(Device deviceObj) throws Exception {
        Device2103.checkDeviceDetection();
        Pointer device = Device2103.openDevice((Device210x)deviceObj);
        byte[] baudConfig = new byte[384];
        int status = CP210xManufacturing.DLL.CP210x_GetBaudRateConfig(device, baudConfig);
        Device2103.close(device);
        CP210xBaudConfig result = new CP210xBaudConfig(baudConfig);
        LOG.logDebug(status, "getBaudConfig", result);
        if (status != 0) {
            throw new Exception("getBaudConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected Property[] createBaudConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP210xGroupBaudConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2103.checkDeviceDetection();
        Pointer device = Device2103.openDevice((Device210x)deviceObj);
        ByteByReference lockValue = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetLockValue(device, lockValue);
        Device2103.close(device);
        String result = status == 0 ? Device2103.toHexString(lockValue.getValue(), 2) : "";
        LOG.logDebug(status, "getLockByte:", result);
        if (status != 0) {
            throw new Exception("getLockByte(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2103.checkDeviceDetection();
        Pointer device = Device2103.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetLockValue(device);
        Device2103.close(device);
        LOG.logDebug(status, "setLockByte:", value);
        if (status != 0) {
            throw new Exception("setLockByte(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EA60");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0100");
        idProps[5].reset("CP2103 USB to UART Bridge Controller");
        idProps[6].reset("0001");
        idProps[7].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2103_4GroupPortConfigRoot cp2103PortConfigRoot = (CP2103_4GroupPortConfigRoot)portConfigProps[0];
        cp2103PortConfigRoot.resetSiliconLabsDefaultValues();
        Property[] baudConfigProps = this.getBaudRates();
        CP210xGroupBaudConfigRoot cp2103BaudConfigRoot = (CP210xGroupBaudConfigRoot)baudConfigProps[0];
        cp2103BaudConfigRoot.resetSiliconLabsDefaultValues();
    }
}

