/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupBaudConfigRoot;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyBaudConfig;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.log.MessageLog;

class CP210xGroupBaudConfigRoot
extends GroupBaudConfigRoot {
    CP210xBaudConfig baudConfig = null;

    public CP210xGroupBaudConfigRoot(Device device) {
        super(device, "CP210xBaudConfigGroup");
        try {
            this.baudConfig = this.readBaudConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        this.children = new PropertyBaudConfig[]{new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "4294967295", "2457601"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "2457600", "1474561"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "1474560", "1053258"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "1053257", "670255"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "670254", "567139"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "567138", "491521"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "491520", "273067"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "273066", "254235"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "254234", "237833"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "237832", "156869"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "156868", "129348"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "129347", "117029"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "117028", "77609"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "77608", "64112"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "64111", "58054"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "58053", "56281"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "56280", "51559"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "51558", "38602"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "38601", "28913"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "28912", "19251"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "19250", "16063"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "16062", "14429"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "14428", "9613"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "9612", "7208"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "7207", "4804"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "4803", "4001"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "4000", "2401"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "2400", "1801"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "1800", "1201"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "1200", "601"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "600", "301"), new PropertyBaudConfig(this.getDevice(), this, i++, 48000000L, 500000L, "300", "57")};
        this.initProperty();
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        CP210xBaudConfig writeConfig = null;
        try {
            writeConfig = this.createBaudConfig();
            if (Application.DRY_RUN) {
                this.updateDefaults(writeConfig);
            } else {
                this.getDevice().setBaudConfig(this.getDevice(), writeConfig);
                CP210xBaudConfig newDefaults = this.readBaudConfig();
                this.updateDefaults(newDefaults);
            }
            this.updateWritten(true);
            this.updateError();
            this.logWrite(this.isError(), null, writeConfig);
        }
        catch (Exception exc) {
            this.logWrite(true, exc, writeConfig);
        }
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        if (this.children != null) {
            this.baudConfig = this.readBaudConfig();
            this.updateDefaults(this.baudConfig);
            this.updateValues(this.baudConfig);
        }
        return "";
    }

    @Override
    protected String getBaudConfig(int index) throws Exception {
        if (this.baudConfig != null) {
            return String.format("%d", this.baudConfig.baudConfigs[index].baudRate);
        }
        throw new NullPointerException("baudConfig");
    }

    private CP210xBaudConfig createBaudConfig() {
        PropertyBaudConfig[] pBaudConfigs = this.getChildren();
        return new CP210xBaudConfig(pBaudConfigs);
    }

    private final void logWrite(boolean error, Exception exc, CP210xBaudConfig writeConfig) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.getDevice().getType(), this.getName(), writeConfig));
        } else {
            String message = String.format("%s FAILED write of %s: %s", this.getDevice().getType(), this.getName(), writeConfig);
            MessageLog.error(message, exc);
        }
    }

    private CP210xBaudConfig readBaudConfig() throws Exception {
        return this.getDevice().getBaudConfig(this.getDevice());
    }

    private void updateDefaults(CP210xBaudConfig config) {
        PropertyBaudConfig[] pBaudConfigs = this.getChildren();
        if (pBaudConfigs.length != this.getChildren().length) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pBaudConfigs.length) {
            String baudValue = String.format("%d", config.baudConfigs[i].baudRate);
            ((Property)pBaudConfigs[i]).setDefaultValue(baudValue);
            ++i;
        }
    }

    private void updateError() {
        PropertyBaudConfig[] propertyBaudConfigArray = this.getChildren();
        int n = propertyBaudConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyBaudConfig prop = propertyBaudConfigArray[n2];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n2;
        }
    }

    private void updateValues(CP210xBaudConfig config) {
        PropertyBaudConfig[] pBaudConfigs = this.getChildren();
        if (pBaudConfigs.length != this.getChildren().length) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pBaudConfigs.length) {
            String baudValue = String.format("%d", config.baudConfigs[i].baudRate);
            ((Property)pBaudConfigs[i]).setValue(baudValue);
            ++i;
        }
    }

    private void updateWritten(boolean written) {
        PropertyBaudConfig[] propertyBaudConfigArray = this.getChildren();
        int n = propertyBaudConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyBaudConfig prop = propertyBaudConfigArray[n2];
            prop.setWritten(written);
            ++n2;
        }
    }

    @Override
    public void resetSiliconLabsDefaultValues() {
        PropertyBaudConfig[] pBaudConfigs = this.getChildren();
        if (pBaudConfigs.length != this.getChildren().length) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        pBaudConfigs[0].reset("1500000");
        pBaudConfigs[1].reset("1500000");
        pBaudConfigs[2].reset("1200000");
        pBaudConfigs[3].reset("921600");
        pBaudConfigs[4].reset("576000");
        pBaudConfigs[5].reset("500000");
        pBaudConfigs[6].reset("460800");
        pBaudConfigs[7].reset("256000");
        pBaudConfigs[8].reset("250000");
        pBaudConfigs[9].reset("230400");
        pBaudConfigs[10].reset("153600");
        pBaudConfigs[11].reset("128000");
        pBaudConfigs[12].reset("115200");
        pBaudConfigs[13].reset("76800");
        pBaudConfigs[14].reset("64000");
        pBaudConfigs[15].reset("57600");
        pBaudConfigs[16].reset("56000");
        pBaudConfigs[17].reset("51200");
        pBaudConfigs[18].reset("38400");
        pBaudConfigs[19].reset("28800");
        pBaudConfigs[20].reset("19200");
        pBaudConfigs[21].reset("16000");
        pBaudConfigs[22].reset("14400");
        pBaudConfigs[23].reset("9600");
        pBaudConfigs[24].reset("7200");
        pBaudConfigs[25].reset("4800");
        pBaudConfigs[26].reset("4000");
        pBaudConfigs[27].reset("2400");
        pBaudConfigs[28].reset("1800");
        pBaudConfigs[29].reset("1200");
        pBaudConfigs[30].reset("600");
        pBaudConfigs[31].reset("300");
    }
}

