/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupPortConfigRoot;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyLatchControl;
import com.silabs.customizer.devices.PropertyResetValue;
import com.silabs.customizer.devices.PropertySuspendValue;
import com.silabs.customizer.devices.PropertyToggleValues;
import com.silabs.customizer.devices.cp210x.CP2105GroupPins;
import com.silabs.customizer.devices.cp210x.CP2105LatchControlCellEditor;
import com.silabs.customizer.devices.cp210x.CP2105PinConfig;
import com.silabs.customizer.devices.cp210x.CP2105ResetValueCellEditor;
import com.silabs.customizer.devices.cp210x.CP2105SuspendValueCellEditor;
import com.silabs.customizer.devices.cp210x.Device2105;
import com.silabs.customizer.log.MessageLog;

class CP2105GroupPortConfigRoot
extends GroupPortConfigRoot {
    public CP2105GroupPortConfigRoot(Device device) {
        super(device, "CP2105PortConfigGroup");
        this.initProperty();
        Property[] propertyArray = new Property[11];
        this.grpPins = new CP2105GroupPins(device);
        propertyArray[0] = this.grpPins;
        this.pUseSciSuspend = new PropertyToggleValues(device, "Dynamic Suspend for SCI", "no", "use suspend value");
        propertyArray[1] = this.pUseSciSuspend;
        this.pUseEciSuspend = new PropertyToggleValues(device, "Dynamic Suspend for ECI", "no", "use suspend value");
        propertyArray[2] = this.pUseEciSuspend;
        this.pSuspendValue = new PropertySuspendValue(device, CP2105SuspendValueCellEditor.getFactory());
        propertyArray[3] = this.pSuspendValue;
        this.pResetValue = new PropertyResetValue(device, CP2105ResetValueCellEditor.getFactory());
        propertyArray[4] = this.pResetValue;
        this.pLatchControl = new PropertyLatchControl(device, CP2105LatchControlCellEditor.getFactory());
        propertyArray[5] = this.pLatchControl;
        this.pEnableWeakPullUp = new PropertyToggleValues(device, "Weak Pull-Up", "disable", "enable");
        propertyArray[6] = this.pEnableWeakPullUp;
        this.p485Invert = new PropertyToggleValues(device, "RS485 Invert", "disable", "enable");
        propertyArray[7] = this.p485Invert;
        this.pECIAutoMode = new PropertyToggleValues(device, "ECI GPIO1 Auto Mode Type", "RXLED", "RS485");
        propertyArray[8] = this.pECIAutoMode;
        this.pInvertSCISuspend = new PropertyToggleValues(device, "Invert SCI Suspend", "disable", "enable");
        propertyArray[9] = this.pInvertSCISuspend;
        this.pInvertECISuspend = new PropertyToggleValues(device, "Invert ECI Suspend", "disable", "enable");
        propertyArray[10] = this.pInvertECISuspend;
        this.children = propertyArray;
        this.pinCount = 14;
        try {
            this.readValueFromDevice();
        }
        catch (Exception exc) {
            this.logReadFailed(device, exc);
        }
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        CP2105PinConfig writeConfig = null;
        try {
            writeConfig = this.createPinConfig();
            if (Application.DRY_RUN) {
                this.updateDefaults(writeConfig);
            } else {
                Device2105.setPinConfig(this.getDevice(), writeConfig);
                CP2105PinConfig newDefaults = this.readPinConfig();
                this.updateDefaults(newDefaults);
            }
            this.updateWritten(true);
            this.updateError();
            this.logWrite(this.isError(), null, writeConfig);
        }
        catch (Exception exc) {
            this.logWrite(true, exc, writeConfig);
        }
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        if (this.children != null) {
            CP2105PinConfig config = this.readPinConfig();
            this.updateDefaults(config);
            this.updateValues(config);
        }
        return "";
    }

    private CP2105PinConfig createPinConfig() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        byte[] pinConfigs = new byte[pPins.length];
        int i = 0;
        while (i < pinConfigs.length) {
            pinConfigs[i] = Byte.parseByte(pPins[i].getValue(), 16);
            ++i;
        }
        int useSCISuspend = Integer.parseInt(this.pUseSciSuspend.getValue(), 16);
        int useECISuspend = Integer.parseInt(this.pUseEciSuspend.getValue(), 16);
        int suspendValue = Integer.parseInt(this.pSuspendValue.getValue(), 16);
        int resetValue = Integer.parseInt(this.pResetValue.getValue(), 16);
        int latchControl = Integer.parseInt(this.pLatchControl.getValue(), 16);
        int enableWeakPullUp = Integer.parseInt(this.pEnableWeakPullUp.getValue(), 16);
        int rs485Invert = Integer.parseInt(this.p485Invert.getValue(), 16);
        int eciAutoMode = Integer.parseInt(this.pECIAutoMode.getValue(), 16);
        int invertSCISuspend = Integer.parseInt(this.pInvertSCISuspend.getValue(), 16);
        int invertECISuspend = Integer.parseInt(this.pInvertECISuspend.getValue(), 16);
        return new CP2105PinConfig(pinConfigs, suspendValue, resetValue, latchControl, useSCISuspend, useECISuspend, enableWeakPullUp, rs485Invert, eciAutoMode, invertSCISuspend, invertECISuspend);
    }

    private final void logWrite(boolean error, Exception exc, CP2105PinConfig config) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.getDevice().getType(), this.getName(), config));
        } else {
            String message = String.format("%s FAILED write of %s: %s", this.getDevice().getType(), this.getName(), config);
            MessageLog.error(message, exc);
        }
    }

    private CP2105PinConfig readPinConfig() throws Exception {
        return Device2105.getPinConfig(this.getDevice());
    }

    private void updateDefaults(CP2105PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pPins.length) {
            String pinValue = String.format("%X", config.pinConfigs[i]);
            pPins[i].setDefaultValue(pinValue);
            ++i;
        }
        this.pUseSciSuspend.setDefaultValue(String.valueOf(config.useSCISuspendValues));
        this.pUseEciSuspend.setDefaultValue(String.valueOf(config.useECISuspendValues));
        this.pSuspendValue.setDefaultValue(String.format("%04X", config.suspendValue));
        this.pResetValue.setDefaultValue(String.format("%04X", config.resetValue));
        this.pLatchControl.setDefaultValue(String.format("%04X", config.latchControl));
        this.pEnableWeakPullUp.setDefaultValue(String.valueOf(config.enableWeakPullUp));
        this.p485Invert.setDefaultValue(String.valueOf(config.rs485Invert));
        this.pECIAutoMode.setDefaultValue(String.valueOf(config.eciAutoMode));
        this.pInvertSCISuspend.setDefaultValue(String.valueOf(config.invertSCISuspend));
        this.pInvertECISuspend.setDefaultValue(String.valueOf(config.invertECISuspend));
    }

    private void updateError() {
        Property[] props;
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n2;
        }
        Property[] propertyArray2 = props = new Property[]{this.pUseSciSuspend, this.pUseEciSuspend, this.pSuspendValue, this.pResetValue, this.pLatchControl, this.pEnableWeakPullUp, this.p485Invert, this.pECIAutoMode, this.pInvertSCISuspend, this.pInvertECISuspend};
        int n3 = props.length;
        n = 0;
        while (n < n3) {
            Property prop = propertyArray2[n];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n;
        }
    }

    private void updateValues(CP2105PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < this.pinCount) {
            String pinValue = String.format("%X", config.pinConfigs[i]);
            pPins[i].setValue(pinValue);
            ++i;
        }
        this.pUseSciSuspend.setValue(String.valueOf(config.useSCISuspendValues));
        this.pUseEciSuspend.setValue(String.valueOf(config.useECISuspendValues));
        this.pSuspendValue.setValue(String.format("%04X", config.suspendValue));
        this.pResetValue.setValue(String.format("%04X", config.resetValue));
        this.pLatchControl.setValue(String.format("%04X", config.latchControl));
        this.pEnableWeakPullUp.setValue(String.valueOf(config.enableWeakPullUp));
        this.p485Invert.setValue(String.valueOf(config.rs485Invert));
        this.pECIAutoMode.setValue(String.valueOf(config.eciAutoMode));
        this.pInvertSCISuspend.setValue(String.valueOf(config.invertSCISuspend));
        this.pInvertECISuspend.setValue(String.valueOf(config.invertECISuspend));
    }

    private void updateWritten(boolean written) {
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            prop.setWritten(written);
            ++n2;
        }
        this.pUseSciSuspend.setWritten(written);
        this.pUseEciSuspend.setWritten(written);
        this.pSuspendValue.setWritten(written);
        this.pResetValue.setWritten(written);
        this.pLatchControl.setWritten(written);
        this.pEnableWeakPullUp.setWritten(written);
        this.p485Invert.setWritten(written);
        this.pECIAutoMode.setWritten(written);
        this.pInvertSCISuspend.setWritten(written);
        this.pInvertECISuspend.setWritten(written);
    }

    @Override
    public void resetSiliconLabsDefaultValues() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        pPins[0].reset("1");
        pPins[1].reset("0");
        pPins[2].reset("0");
        pPins[3].reset("0");
        pPins[4].reset("1");
        pPins[5].reset("1");
        pPins[6].reset("0");
        pPins[7].reset("1");
        pPins[8].reset("0");
        pPins[9].reset("0");
        pPins[10].reset("0");
        pPins[11].reset("1");
        pPins[12].reset("1");
        pPins[13].reset("0");
        this.pUseSciSuspend.reset("0");
        this.pUseEciSuspend.reset("0");
        this.pSuspendValue.reset("FEFE");
        this.pResetValue.reset("FEFE");
        this.pLatchControl.reset("0000");
        this.pEnableWeakPullUp.reset("1");
        this.p485Invert.reset("0");
        this.pECIAutoMode.reset("0");
        this.pInvertSCISuspend.reset("1");
        this.pInvertECISuspend.reset("1");
    }
}

