/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupPortConfigRoot;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyLatchControl;
import com.silabs.customizer.devices.PropertyResetValue;
import com.silabs.customizer.devices.PropertySuspendValue;
import com.silabs.customizer.devices.PropertyToggleValues;
import com.silabs.customizer.devices.cp210x.CP2103_4GroupPins;
import com.silabs.customizer.devices.cp210x.CP2103_4LatchControlCellEditor;
import com.silabs.customizer.devices.cp210x.CP2103_4PinConfig;
import com.silabs.customizer.devices.cp210x.CP2103_4ResetValueCellEditor;
import com.silabs.customizer.devices.cp210x.CP2103_4SuspendValueCellEditor;
import com.silabs.customizer.devices.cp210x.Device2103;
import com.silabs.customizer.log.MessageLog;

class CP2103_4GroupPortConfigRoot
extends GroupPortConfigRoot {
    public CP2103_4GroupPortConfigRoot(Device device) {
        super(device, "CP2103_4PortConfigGroup");
        Property[] propertyArray = new Property[8];
        this.grpPins = new CP2103_4GroupPins(device);
        propertyArray[0] = this.grpPins;
        this.pUseUartSuspend = new PropertyToggleValues(device, "Dynamic Suspend for UART/Modem", "no", "use suspend value");
        propertyArray[1] = this.pUseUartSuspend;
        this.pUseGPIOSuspend = new PropertyToggleValues(device, "Dynamic Suspend for GPIO", "no", "use suspend value");
        propertyArray[2] = this.pUseGPIOSuspend;
        this.pSuspendValue = new PropertySuspendValue(device, CP2103_4SuspendValueCellEditor.getFactory());
        propertyArray[3] = this.pSuspendValue;
        this.pResetValue = new PropertyResetValue(device, CP2103_4ResetValueCellEditor.getFactory());
        propertyArray[4] = this.pResetValue;
        this.pLatchControl = new PropertyLatchControl(device, CP2103_4LatchControlCellEditor.getFactory());
        propertyArray[5] = this.pLatchControl;
        this.pEnableWeakPullUp = new PropertyToggleValues(device, "Weak Pull-Up", "disable", "enable");
        propertyArray[6] = this.pEnableWeakPullUp;
        this.p485Invert = new PropertyToggleValues(device, "RS485 Invert", "active-high", "active-low");
        propertyArray[7] = this.p485Invert;
        this.children = propertyArray;
        this.pinCount = 13;
        this.initProperty();
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        CP2103_4PinConfig writeConfig = null;
        try {
            writeConfig = this.createPinConfig();
            if (Application.DRY_RUN) {
                this.updateDefaults(writeConfig);
            } else {
                Device2103.setPinConfig(this.getDevice(), writeConfig);
                CP2103_4PinConfig newDefaults = this.readPinConfig();
                this.updateDefaults(newDefaults);
            }
            this.updateWritten(true);
            this.updateError();
            this.logWrite(this.isError(), null, writeConfig);
        }
        catch (Exception exc) {
            this.logWrite(true, exc, writeConfig);
        }
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        if (this.children != null) {
            CP2103_4PinConfig config = this.readPinConfig();
            this.updateDefaults(config);
            this.updateValues(config);
        }
        return "";
    }

    private CP2103_4PinConfig createPinConfig() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        byte[] pinConfigs = new byte[pPins.length];
        int i = 0;
        while (i < pinConfigs.length) {
            pinConfigs[i] = Byte.parseByte(pPins[i].getValue(), 16);
            ++i;
        }
        int useUartSuspend = Integer.parseInt(this.pUseUartSuspend.getValue(), 16);
        int useGPIOSuspend = Integer.parseInt(this.pUseGPIOSuspend.getValue(), 16);
        int suspendValue = Integer.parseInt(this.pSuspendValue.getValue(), 16);
        int resetValue = Integer.parseInt(this.pResetValue.getValue(), 16);
        int latchControl = Integer.parseInt(this.pLatchControl.getValue(), 16);
        if ((latchControl & 0x100) != 0) {
            resetValue |= 0x100;
            suspendValue |= 0x100;
        }
        if ((latchControl & 0x200) != 0) {
            resetValue |= 0x200;
            suspendValue |= 0x200;
        }
        if ((latchControl & 0x400) != 0) {
            resetValue |= 0x400;
            suspendValue |= 0x400;
        }
        this.pSuspendValue.setValue(String.format("%04X", suspendValue));
        this.pResetValue.setValue(String.format("%04X", resetValue));
        int enableWeakPullUp = Integer.parseInt(this.pEnableWeakPullUp.getValue(), 16);
        int rs485Invert = Integer.parseInt(this.p485Invert.getValue(), 16);
        return new CP2103_4PinConfig(pinConfigs, useUartSuspend, useGPIOSuspend, suspendValue, resetValue, latchControl, enableWeakPullUp, rs485Invert);
    }

    private final void logWrite(boolean error, Exception exc, CP2103_4PinConfig config) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.getDevice().getType(), this.getName(), config));
        } else {
            String message = String.format("%s FAILED write of %s: %s", this.getDevice().getType(), this.getName(), config);
            MessageLog.error(message, exc);
        }
    }

    private CP2103_4PinConfig readPinConfig() throws Exception {
        return Device2103.getPinConfig(this.getDevice());
    }

    private void updateDefaults(CP2103_4PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pPins.length) {
            String pinValue = String.format("%X", config.pinConfigs[i]);
            pPins[i].setDefaultValue(pinValue);
            ++i;
        }
        this.pUseUartSuspend.setDefaultValue(String.valueOf(config.useUartSuspendValues));
        this.pUseGPIOSuspend.setDefaultValue(String.valueOf(config.useGPIOSuspendValues));
        this.pSuspendValue.setDefaultValue(String.format("%04X", config.suspendValue));
        this.pResetValue.setDefaultValue(String.format("%04X", config.resetValue));
        this.pLatchControl.setDefaultValue(String.format("%04X", config.latchControl));
        this.pEnableWeakPullUp.setDefaultValue(String.valueOf(config.enableWeakPullUp));
        this.p485Invert.setDefaultValue(String.valueOf(config.rs485Invert));
    }

    private void updateError() {
        Property[] props;
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n2;
        }
        Property[] propertyArray2 = props = new Property[]{this.pUseUartSuspend, this.pUseGPIOSuspend, this.pSuspendValue, this.pResetValue, this.pEnableWeakPullUp, this.p485Invert};
        int n3 = props.length;
        n = 0;
        while (n < n3) {
            Property prop = propertyArray2[n];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n;
        }
    }

    private void updateValues(CP2103_4PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < this.pinCount) {
            String pinValue = String.format("%X", config.pinConfigs[i]);
            pPins[i].setValue(pinValue);
            ++i;
        }
        this.pUseUartSuspend.setValue(String.valueOf(config.useUartSuspendValues));
        this.pUseGPIOSuspend.setValue(String.valueOf(config.useGPIOSuspendValues));
        this.pSuspendValue.setValue(String.format("%04X", config.suspendValue));
        this.pResetValue.setValue(String.format("%04X", config.resetValue));
        this.pLatchControl.setValue(String.format("%04X", config.latchControl));
        this.pEnableWeakPullUp.setValue(String.valueOf(config.enableWeakPullUp));
        this.p485Invert.setValue(String.valueOf(config.rs485Invert));
    }

    private void updateWritten(boolean written) {
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            prop.setWritten(written);
            ++n2;
        }
        this.pUseUartSuspend.setWritten(written);
        this.pUseGPIOSuspend.setWritten(written);
        this.pSuspendValue.setWritten(written);
        this.pResetValue.setWritten(written);
        this.pLatchControl.setWritten(written);
        this.pEnableWeakPullUp.setWritten(written);
        this.p485Invert.setWritten(written);
    }

    @Override
    public void resetSiliconLabsDefaultValues() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        pPins[0].reset("0");
        pPins[1].reset("0");
        pPins[2].reset("1");
        pPins[3].reset("0");
        pPins[4].reset("1");
        pPins[5].reset("1");
        pPins[6].reset("0");
        pPins[7].reset("1");
        pPins[8].reset("1");
        pPins[9].reset("0");
        pPins[10].reset("0");
        pPins[11].reset("0");
        pPins[12].reset("0");
        this.pUseUartSuspend.reset("0");
        this.pUseGPIOSuspend.reset("0");
        this.pSuspendValue.reset("3FFF");
        this.pResetValue.reset("3FFF");
        this.pLatchControl.reset("0000");
        this.pEnableWeakPullUp.reset("1");
        this.p485Invert.reset("0");
    }
}

