/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.IOVisitor;
import com.silabs.customizer.devices.Property;
import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class SaveVisitor
extends IOVisitor {
    private Properties props;

    public static final void save(File file, Device device) throws Exception {
        SaveVisitor visitor = new SaveVisitor();
        device.visit(visitor);
        FileWriter writer = new FileWriter(file, false);
        try {
            Properties props = visitor.getProperties();
            props.store(writer, SaveVisitor.getComment());
        }
        finally {
            writer.close();
        }
    }

    private static String getComment() {
        Bundle bundle = Platform.getBundle((String)"com.silabs.customizer");
        String comment = null;
        if (bundle != null) {
            comment = String.format("%s_%s", bundle.getSymbolicName(), bundle.getVersion().toString());
        }
        return comment;
    }

    SaveVisitor() {
    }

    @Override
    public void enter(Device device) {
        super.enter(device);
        this.props = new Properties();
        this.props.setProperty("device", device.getType());
        this.props.setProperty("version", "2");
    }

    protected Properties getProperties() {
        if (this.props == null) {
            throw new IllegalStateException("visit first");
        }
        return this.props;
    }

    @Override
    protected void accept(Property property, String key) {
        this.props.put(key, property.getValue());
    }
}

