/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.preferences.PreferenceConstants;

public class PropertySerial
extends Property {
    private int maxLength;

    public PropertySerial(Device device, int maxLength) {
        super(device, null, "Serial", null);
        this.maxLength = maxLength;
        this.initProperty();
    }

    @Override
    public final boolean isSerial() {
        return true;
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        super.program();
        if (this.isWritten() && !this.isError()) {
            if (PreferenceConstants.incrementSerial()) {
                this.setValue(PreferenceConstants.getSerial());
            }
            this.setDefaultValue(this.getValue());
        }
    }

    @Override
    public void setValue(String value) {
        String newValue;
        String auto = PreferenceConstants.getSerial();
        String string = newValue = auto == null ? value : auto;
        if (newValue.length() > this.maxLength) {
            this.setError(true);
            MessageLog.error(String.format("Serial number too long (limit=%d).", this.maxLength), null);
        }
        super.setValue(auto == null ? value : auto);
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return this.getDevice().getSerial(this.getDevice());
    }

    @Override
    protected void writeToDevice() throws Exception {
        this.getDevice().setSerial(this.getDevice(), this.getValue());
    }

    @Override
    public String getXMLValue() {
        String serialString = this.getValue();
        String xmlValueString = "  <field name=\"serialStringUtf8Usb\" size=\"34\" type=\"blob\">\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <comment>" + serialString + "</comment>\n";
        xmlValueString = String.valueOf(xmlValueString) + "    <value>";
        int stringIndex = 0;
        while (stringIndex < this.maxLength - 1) {
            xmlValueString = stringIndex < serialString.length() ? String.valueOf(xmlValueString) + "0x" + String.format("%02X, ", serialString.getBytes()[stringIndex]) : String.valueOf(xmlValueString) + "0x00, ";
            ++stringIndex;
        }
        xmlValueString = String.valueOf(xmlValueString) + "0x00</value>\n";
        xmlValueString = String.valueOf(xmlValueString) + "  </field>";
        return xmlValueString;
    }
}

