/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.IOVisitor;
import com.silabs.customizer.devices.Property;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public final class LoadVisitor
extends IOVisitor {
    private final Properties props;

    public static final void load(File file, Device device) throws Exception {
        Properties props = LoadVisitor.loadProperties(file);
        LoadVisitor.checkVersion(props);
        LoadVisitor.checkDevice(props, device);
        LoadVisitor visitor = new LoadVisitor(props);
        device.visit(visitor);
    }

    private static void checkDevice(Properties props, Device device) throws IOException {
        String deviceType = props.getProperty("device");
        if (deviceType == null) {
            throw new IOException("Unknown device");
        }
        if (!deviceType.equals(device.getType())) {
            throw new IOException(String.format("Device type (%s) does not match current device (%s)", deviceType, device.getType()));
        }
    }

    private static void checkVersion(Properties props) throws IOException {
        String version = props.getProperty("version");
        if (version == null) {
            throw new IOException("Unknown file version");
        }
        if (!"2".equals(version)) {
            throw new IOException(String.format("Unsupported file version (%s)", version));
        }
    }

    private static Properties loadProperties(File file) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileReader reader = new FileReader(file);
        try {
            props.load(reader);
        }
        finally {
            reader.close();
        }
        return props;
    }

    LoadVisitor(Properties props) {
        if (props == null) {
            throw new NullPointerException("props");
        }
        this.props = props;
    }

    @Override
    protected void accept(Property property, String key) {
        String value = this.props.getProperty(key);
        if (value != null && !value.equals(property.getValue())) {
            property.setValue(value);
        }
    }
}

