/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.IDeviceVisitor;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.cp210x.CP210xBaudConfig;
import com.silabs.customizer.log.MessageLog;

public abstract class Device
implements Comparable<Device> {
    private boolean isOTP = false;
    private boolean showConfigureIds;
    private boolean showConfigureBaudRate;
    private boolean showConfigurePins;
    private Property[] ids;
    private Property[] portConfigs;
    private Property[] baudConfigs;
    private String programmedSerialNumber;
    protected static int maxDeviceStrlen = 256;
    protected int maxManufacturerStrlen = 45;
    protected int maxProductStrlen = 126;
    protected static int maxSerialStrlen = 63;
    protected int maxInterfaceStrlen = 0;

    @Override
    public final int compareTo(Device device) {
        return this.getName().compareTo(device.getName());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        return !(this.getDeviceString() == null ? other.getDeviceString() != null : !this.getDeviceString().equals(other.getDeviceString()));
    }

    public final Property[] getIds() {
        if (this.ids == null) {
            this.ids = this.createIds();
        }
        Property[] result = new Property[this.ids.length];
        System.arraycopy(this.ids, 0, result, 0, result.length);
        return result;
    }

    public final Property[] getPortConfigs() {
        if (this.portConfigs == null) {
            this.portConfigs = this.createPortConfigs();
        }
        Property[] result = new Property[this.portConfigs.length];
        System.arraycopy(this.portConfigs, 0, result, 0, result.length);
        return result;
    }

    public Property[] getBaudRates() {
        if (this.baudConfigs == null) {
            this.baudConfigs = this.createBaudConfigs();
        }
        Property[] result = new Property[this.baudConfigs.length];
        System.arraycopy(this.baudConfigs, 0, result, 0, result.length);
        return result;
    }

    public abstract String getName();

    public abstract String getDeviceString();

    public abstract String getSerial();

    public abstract void setSerial(String var1);

    public abstract String getVID(Device var1) throws Exception;

    public abstract void setVID(Device var1, String var2) throws Exception;

    public abstract String getPID(Device var1) throws Exception;

    public abstract void setPID(Device var1, String var2) throws Exception;

    public abstract String getSerial(Device var1) throws Exception;

    public abstract void setSerial(Device var1, String var2) throws Exception;

    public abstract String getReleaseVersion(Device var1) throws Exception;

    public abstract void setReleaseVersion(Device var1, String var2) throws Exception;

    public abstract String getProduct(Device var1) throws Exception;

    public abstract void setProduct(Device var1, String var2) throws Exception;

    public abstract String getPowerMode(Device var1) throws Exception;

    public abstract void setPowerMode(Device var1, String var2) throws Exception;

    public abstract String getPower(Device var1) throws Exception;

    public abstract void setPower(Device var1, String var2) throws Exception;

    public abstract void setBaudConfig(Device var1, CP210xBaudConfig var2) throws Exception;

    public abstract CP210xBaudConfig getBaudConfig(Device var1) throws Exception;

    public abstract String getManufacturer(Device var1) throws Exception;

    public abstract void setManufacturer(Device var1, String var2) throws Exception;

    public abstract String getInterfaceString(Device var1, int var2) throws Exception;

    public abstract void setInterfaceString(Device var1, int var2, String var3) throws Exception;

    public abstract String getFlushBuffers(Device var1) throws Exception;

    public abstract void setFlushBuffers(Device var1, String var2) throws Exception;

    public abstract String getDeviceMode(Device var1) throws Exception;

    public abstract void setDeviceMode(Device var1, String var2) throws Exception;

    public abstract String getTransferPriority(Device var1) throws Exception;

    public abstract void setTransferPriority(Device var1, String var2) throws Exception;

    public abstract String getLockValue(Device var1) throws Exception;

    public abstract void setLockValue(Device var1, String var2) throws Exception;

    public abstract String getType();

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean isOTP() {
        return this.isOTP;
    }

    public final boolean isShowConfigureBaudRate() {
        return this.showConfigureBaudRate;
    }

    public final boolean isShowConfigureIds() {
        return this.showConfigureIds;
    }

    public final boolean isShowConfigurePins() {
        return this.showConfigurePins;
    }

    public void program() {
        DeviceDetector.getDefault().stop();
        try {
            MessageLog log = new MessageLog();
            log.logInfo("Device programming started...");
            Property pSerial = null;
            Property pLockValue = null;
            Property[] propertyArray = this.getIds();
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property pId = propertyArray[n2];
                if (pId.isSerial()) {
                    pSerial = pId;
                } else if (pId.isLockValue()) {
                    pLockValue = pId;
                } else {
                    pId.program();
                }
                ++n2;
            }
            propertyArray = this.getPortConfigs();
            n = propertyArray.length;
            n2 = 0;
            while (n2 < n) {
                Property port = propertyArray[n2];
                port.program();
                ++n2;
            }
            propertyArray = this.getBaudRates();
            n = propertyArray.length;
            n2 = 0;
            while (n2 < n) {
                Property baudConfig = propertyArray[n2];
                baudConfig.program();
                ++n2;
            }
            if (pSerial == null) {
                throw new NullPointerException("pSerial");
            }
            pSerial.program();
            this.programmedSerialNumber = pSerial.getValue();
            if (pLockValue != null) {
                pLockValue.program();
            }
            log.logInfo("Device programming completed.");
            log.dispose();
        }
        finally {
            DeviceDetector.getDefault().start();
        }
    }

    public void verify() {
        try {
            MessageLog log = new MessageLog();
            log.logInfo("Device verification started...");
            Property pSerial = null;
            Property[] propertyArray = this.getIds();
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property pId = propertyArray[n2];
                if (pId.isSerial()) {
                    pSerial = pId;
                } else if (pId.needsVerification()) {
                    pId.verify();
                }
                ++n2;
            }
            propertyArray = this.getBaudRates();
            n = propertyArray.length;
            n2 = 0;
            while (n2 < n) {
                Property bauds = propertyArray[n2];
                if (bauds.needsVerification()) {
                    bauds.verify();
                }
                ++n2;
            }
            propertyArray = this.getPortConfigs();
            n = propertyArray.length;
            n2 = 0;
            while (n2 < n) {
                Property port = propertyArray[n2];
                if (port.needsVerification()) {
                    port.verify();
                }
                ++n2;
            }
            if (pSerial != null && pSerial.needsVerification() && this.programmedSerialNumber.equals(pSerial.getValue())) {
                pSerial.setDefaultValue(this.programmedSerialNumber);
            }
            log.logInfo("Device verification completed.");
            log.dispose();
        }
        finally {
            DeviceDetector.getDefault().start();
        }
    }

    public abstract void resetDevice() throws Exception;

    public final void resetValues() {
        Property prop;
        Property[] propertyArray = this.getIds();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            prop = propertyArray[n2];
            prop.reset();
            ++n2;
        }
        propertyArray = this.getBaudRates();
        n = propertyArray.length;
        n2 = 0;
        while (n2 < n) {
            prop = propertyArray[n2];
            prop.reset();
            ++n2;
        }
        propertyArray = this.getPortConfigs();
        n = propertyArray.length;
        n2 = 0;
        while (n2 < n) {
            prop = propertyArray[n2];
            prop.reset();
            ++n2;
        }
    }

    public abstract void resetSiliconLabsDefaultValues();

    public final void setOTP(boolean isOTP) {
        this.isOTP = isOTP;
    }

    public final String toString() {
        return this.getName();
    }

    public final void visit(IDeviceVisitor visitor) {
        Property prop;
        visitor.enter(this);
        Property[] propertyArray = this.getIds();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            prop = propertyArray[n2];
            prop.visit(visitor);
            ++n2;
        }
        propertyArray = this.getBaudRates();
        n = propertyArray.length;
        n2 = 0;
        while (n2 < n) {
            prop = propertyArray[n2];
            prop.visit(visitor);
            ++n2;
        }
        propertyArray = this.getPortConfigs();
        n = propertyArray.length;
        n2 = 0;
        while (n2 < n) {
            prop = propertyArray[n2];
            prop.visit(visitor);
            ++n2;
        }
        visitor.leave(this);
    }

    protected abstract Property[] createIds();

    protected abstract Property[] createPortConfigs();

    protected abstract Property[] createBaudConfigs();

    protected final void setShowConfigureBaudRate(boolean showConfigureBaudRate) {
        this.showConfigureBaudRate = showConfigureBaudRate;
    }

    protected final void setShowConfigureIds(boolean showConfigureIds) {
        this.showConfigureIds = showConfigureIds;
    }

    protected final void setShowConfigurePins(boolean showConfigurePins) {
        this.showConfigurePins = showConfigurePins;
    }
}

