/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.actions;

import com.silabs.customizer.UIConstants;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.devices.SaveVisitor;
import com.silabs.customizer.log.MessageLog;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveAction
extends Action
implements ISelectionChangedListener {
    private final Shell shell;
    private Device device;

    public SaveAction(Shell shell) {
        super("&Save Configuration");
        this.setId(SaveAction.class.getName());
        if (UIConstants.isWsCocoa()) {
            this.setAccelerator(4194387);
        } else {
            this.setAccelerator(262227);
        }
        this.setEnabled(false);
        this.shell = shell;
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.shell, 8192);
        dialog.setText("Save Device Configuration");
        dialog.setOverwrite(true);
        dialog.setFilterExtensions(new String[]{"*.txt"});
        String filename = dialog.open();
        if (filename != null) {
            this.handleSave(filename);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            this.device = first instanceof Device && !(first instanceof DeviceNone) ? (Device)first : null;
            this.setEnabled(this.device != null);
        }
    }

    private void handleSave(String filename) {
        try {
            SaveVisitor.save(new File(filename), this.device);
            MessageLog.info("Saved to: " + filename);
        }
        catch (Exception exc) {
            MessageLog.error(String.format("Save FAILED - %s - %s", exc.getMessage(), filename), exc);
        }
    }
}

