/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer;

import com.silabs.customizer.UIConstants;
import com.silabs.customizer.actions.AudioInterfaceConfigAction;
import com.silabs.customizer.actions.ExitAction;
import com.silabs.customizer.actions.LoadAction;
import com.silabs.customizer.actions.PreferencesAction;
import com.silabs.customizer.actions.RestoreDeviceDefaultsAction;
import com.silabs.customizer.actions.RestoreSiliconLabsDefaultsAction;
import com.silabs.customizer.actions.SaveAction;
import com.silabs.customizer.actions.TBDAction;
import com.silabs.customizer.devices.AutoSaveOnExit;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.ui.ConfigurationComposite;
import com.silabs.customizer.ui.DevicesComposite;
import com.silabs.customizer.ui.LoggingComposite;
import com.silabs.nebula.widgets.pgroup.AbstractGroupStrategy;
import com.silabs.nebula.widgets.pgroup.AbstractRenderer;
import com.silabs.nebula.widgets.pgroup.FormRectangleGroupStrategy;
import com.silabs.nebula.widgets.pgroup.PGroup;
import com.silabs.nebula.widgets.pgroup.TwisteToggleRenderer;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class Application
implements IApplication,
ISelectionChangedListener {
    public static boolean DRY_RUN;
    private final AutoSaveOnExit autoSave = new AutoSaveOnExit();
    private LoadAction actionLoad;
    private SaveAction actionSave;
    private RestoreDeviceDefaultsAction actionDefaults;
    private RestoreSiliconLabsDefaultsAction actionSLDefaults;
    private PreferencesAction actionPrefs;
    private AudioInterfaceConfigAction actionDacConfig;
    private DevicesComposite cmpDevices;
    private ConfigurationComposite cmpConfig;
    private Image imageIcon;
    private Device device;
    private Display display;
    private Shell shell;

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Object start(IApplicationContext context) throws Exception {
        Display.setAppName((String)"CP21xx Customization Utility");
        this.display = Display.getDefault();
        if (System.getProperty("jna.library.path") == null) {
            Location installLoc = Platform.getInstallLocation();
            URL installLocURL = installLoc.getURL();
            String path = String.valueOf(new File(installLocURL.getPath()).getAbsolutePath()) + '/';
            System.setProperty("jna.library.path", path);
            System.out.println(path);
        }
        this.shell = this.createShell(this.display);
        this.shell.setSize(600, 650);
        this.shell.open();
        this.shell.moveAbove(null);
        DRY_RUN = this.isDryRun(context);
        try {
            this.processEvents(this.display, this.shell);
        }
        finally {
            this.autoSave.save();
            this.display.dispose();
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
        this.imageIcon.dispose();
    }

    private void addListeners() {
        this.cmpDevices.addSelectionChangedListener(this);
        Viewer[] viewerArray = this.cmpConfig.getViewers();
        int n = viewerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Viewer viewer = viewerArray[n2];
            this.actionLoad.addViewer(viewer);
            this.actionDefaults.addViewer(viewer);
            this.actionSLDefaults.addViewer(viewer);
            this.actionPrefs.addViewer(viewer);
            ++n2;
        }
        this.cmpDevices.addSelectionChangedListener(this.actionPrefs);
        this.cmpDevices.addSelectionChangedListener(this.cmpConfig);
        this.cmpDevices.addSelectionChangedListener(this.actionLoad);
        this.cmpDevices.addSelectionChangedListener(this.actionSave);
        this.cmpDevices.addSelectionChangedListener(this.actionDefaults);
        this.cmpDevices.addSelectionChangedListener(this.actionSLDefaults);
        this.cmpDevices.addSelectionChangedListener(this.actionDacConfig);
        this.cmpDevices.addSelectionChangedListener(this.autoSave);
        this.cmpConfig.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.cmpConfig);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.actionLoad);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.actionSave);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.actionDefaults);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.actionSLDefaults);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.actionDacConfig);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.autoSave);
                Application.this.cmpDevices.removeSelectionChangedListener(Application.this.actionPrefs);
                Viewer[] viewerArray = Application.this.cmpConfig.getViewers();
                int n = viewerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Viewer viewer = viewerArray[n2];
                    Application.this.actionLoad.removeViewer(viewer);
                    Application.this.actionDefaults.removeViewer(viewer);
                    Application.this.actionSLDefaults.removeViewer(viewer);
                    Application.this.actionPrefs.removeViewer(viewer);
                    ++n2;
                }
            }
        });
    }

    private PGroup createGroup(Composite parent, String title) {
        PGroup result = new PGroup(parent, 0);
        result.setText(title);
        result.setStrategy((AbstractGroupStrategy)new FormRectangleGroupStrategy());
        result.setToggleRenderer((AbstractRenderer)new TwisteToggleRenderer());
        return result;
    }

    private Menu createMenuBar(Shell shell) {
        MenuManager mFile = new MenuManager("&File");
        this.actionLoad = new LoadAction(shell);
        mFile.add((IAction)this.actionLoad);
        this.actionSave = new SaveAction(shell);
        mFile.add((IAction)this.actionSave);
        if (!UIConstants.isWsCocoa()) {
            mFile.add((IContributionItem)new Separator());
            mFile.add((IAction)new ExitAction(shell));
        }
        MenuManager mAdvancedConfiguration = new MenuManager("&Advanced");
        this.actionDacConfig = new AudioInterfaceConfigAction(this, shell);
        mAdvancedConfiguration.add((IAction)this.actionDacConfig);
        MenuManager mSettings = new MenuManager("&Settings");
        this.actionDefaults = new RestoreDeviceDefaultsAction();
        mSettings.add((IAction)this.actionDefaults);
        this.actionSLDefaults = new RestoreSiliconLabsDefaultsAction();
        mSettings.add((IAction)this.actionSLDefaults);
        mSettings.add((IContributionItem)new Separator());
        this.actionPrefs = new PreferencesAction(shell);
        mSettings.add((IAction)this.actionPrefs);
        MenuManager mHelp = new MenuManager("&Help");
        mHelp.add((IAction)new TBDAction());
        MenuManager menu = new MenuManager();
        menu.add((IContributionItem)mFile);
        menu.add((IContributionItem)mSettings);
        menu.add((IContributionItem)mAdvancedConfiguration);
        Menu result = menu.createMenuBar((Decorations)shell);
        menu.updateAll(true);
        return result;
    }

    private Shell createShell(Display display) {
        Shell result = new Shell(display);
        result.setText("CP21xx Customization Utility");
        result.setMenuBar(this.createMenuBar(result));
        this.imageIcon = new Image((org.eclipse.swt.graphics.Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/sls_128x128.png"));
        result.setImage(this.imageIcon);
        PGroup pgDevices = this.createGroup((Composite)result, "Device Selection");
        pgDevices.setToggleRenderer(null);
        this.cmpDevices = new DevicesComposite((Composite)pgDevices, 0);
        PGroup pgConfig = this.createGroup((Composite)result, "Device Configuration");
        pgConfig.setToggleRenderer(null);
        this.cmpConfig = new ConfigurationComposite((Composite)pgConfig, 0);
        PGroup pgLogging = this.createGroup((Composite)result, "Status Logging");
        LoggingComposite cmpLogging = new LoggingComposite((Composite)pgLogging, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 1).applyTo((Composite)result);
        GridDataFactory gdf = GridDataFactory.fillDefaults().grab(true, false);
        gdf.applyTo((Control)pgDevices);
        gdf.copy().grab(true, true).applyTo((Control)pgConfig);
        gdf.applyTo((Control)pgLogging);
        GridLayoutFactory glf = GridLayoutFactory.fillDefaults().numColumns(1);
        glf.applyTo((Composite)pgDevices);
        glf.applyTo((Composite)pgConfig);
        glf.applyTo((Composite)pgLogging);
        gdf.applyTo((Control)this.cmpDevices);
        gdf.copy().grab(true, true).applyTo((Control)this.cmpConfig);
        gdf.applyTo((Control)cmpLogging);
        this.addListeners();
        result.pack();
        return result;
    }

    private boolean isDryRun(IApplicationContext context) {
        boolean result = false;
        Object value = context.getArguments().get("application.args");
        if (value instanceof String[]) {
            Object[] args = (String[])value;
            result = Arrays.toString(args).contains("-dry-run");
        }
        if (result) {
            MessageLog.info("-dry-run: ENABLED - no actual device writes");
        }
        return result;
    }

    private void processEvents(Display display, Shell shell) {
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            if (first instanceof Device && !(first instanceof DeviceNone)) {
                this.setDevice((Device)first);
                DeviceDetector.getDefault().setSelectedDevice((Device)first);
            } else {
                this.setDevice(null);
            }
        }
    }
}

