/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.nebula.widgets.pgroup.internal;

import java.awt.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GraphicUtils {
    private static void drawRoundCorner(GC gc, int x, int y, org.eclipse.swt.graphics.Color outerColor, org.eclipse.swt.graphics.Color borderColor, org.eclipse.swt.graphics.Color innerColor, boolean top, boolean left) {
        int[][] i;
        org.eclipse.swt.graphics.Color fore = gc.getForeground();
        int[][] corner = null;
        if (top && !left) {
            int[][] nArrayArray = new int[5][];
            nArrayArray[0] = new int[5];
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = 1;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 2;
            nArray2[1] = 2;
            nArray2[2] = 1;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[5];
            nArray3[0] = 2;
            nArray3[1] = 2;
            nArray3[2] = 2;
            nArray3[3] = 1;
            nArrayArray[3] = nArray3;
            int[] nArray4 = new int[5];
            nArray4[0] = 2;
            nArray4[1] = 2;
            nArray4[2] = 2;
            nArray4[3] = 1;
            nArrayArray[4] = nArray4;
            corner = i = nArrayArray;
        } else if (!top && left) {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 2;
            nArray[4] = 2;
            nArrayArray[0] = nArray;
            int[] nArray5 = new int[5];
            nArray5[1] = 1;
            nArray5[2] = 2;
            nArray5[3] = 2;
            nArray5[4] = 2;
            nArrayArray[1] = nArray5;
            int[] nArray6 = new int[5];
            nArray6[2] = 1;
            nArray6[3] = 2;
            nArray6[4] = 2;
            nArrayArray[2] = nArray6;
            int[] nArray7 = new int[5];
            nArray7[3] = 1;
            nArray7[4] = 1;
            nArrayArray[3] = nArray7;
            nArrayArray[4] = new int[5];
            corner = i = nArrayArray;
        } else if (!top && !left) {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[1] = 2;
            nArray[2] = 2;
            nArray[3] = 1;
            nArrayArray[0] = nArray;
            int[] nArray8 = new int[5];
            nArray8[0] = 2;
            nArray8[1] = 2;
            nArray8[2] = 2;
            nArray8[3] = 1;
            nArrayArray[1] = nArray8;
            int[] nArray9 = new int[5];
            nArray9[0] = 2;
            nArray9[1] = 2;
            nArray9[2] = 1;
            nArrayArray[2] = nArray9;
            int[] nArray10 = new int[5];
            nArray10[0] = 1;
            nArray10[1] = 1;
            nArrayArray[3] = nArray10;
            nArrayArray[4] = new int[5];
            corner = i = nArrayArray;
        } else {
            int[][] nArrayArray = new int[5][];
            nArrayArray[0] = new int[5];
            int[] nArray = new int[5];
            nArray[3] = 1;
            nArray[4] = 1;
            nArrayArray[1] = nArray;
            int[] nArray11 = new int[5];
            nArray11[2] = 1;
            nArray11[3] = 2;
            nArray11[4] = 2;
            nArrayArray[2] = nArray11;
            int[] nArray12 = new int[5];
            nArray12[1] = 1;
            nArray12[2] = 2;
            nArray12[3] = 2;
            nArray12[4] = 2;
            nArrayArray[3] = nArray12;
            int[] nArray13 = new int[5];
            nArray13[1] = 1;
            nArray13[2] = 2;
            nArray13[3] = 2;
            nArray13[4] = 2;
            nArrayArray[4] = nArray13;
            corner = i = nArrayArray;
        }
        int i2 = 0;
        while (i2 < 3) {
            block14: {
                block16: {
                    block15: {
                        block13: {
                            if (i2 != 0) break block13;
                            if (outerColor == null) break block14;
                            gc.setForeground(outerColor);
                        }
                        if (i2 != 1) break block15;
                        if (borderColor == null) break block14;
                        gc.setForeground(borderColor);
                    }
                    if (i2 != 2) break block16;
                    if (innerColor == null) break block14;
                    gc.setForeground(innerColor);
                }
                int line = 0;
                while (line < 5) {
                    int x2 = 0;
                    while (x2 < 5) {
                        if (corner[line][x2] == i2) {
                            gc.drawPoint(x + x2, y + line);
                        }
                        ++x2;
                    }
                    ++line;
                }
            }
            ++i2;
        }
        gc.setForeground(fore);
    }

    public static void drawRoundRectangle(GC gc, int x, int y, int width, int height, org.eclipse.swt.graphics.Color outerColor) {
        GraphicUtils.drawRoundRectangle(gc, x, y, width, height, outerColor, true, true);
    }

    public static void fillGradientRectangle(GC gc, int x, int y, int width, int height, org.eclipse.swt.graphics.Color[] gradientColors, int[] gradientPercents, boolean vertical) {
        org.eclipse.swt.graphics.Color oldBackground = gc.getBackground();
        if (gradientColors.length == 1) {
            if (gradientColors[0] != null) {
                gc.setBackground(gradientColors[0]);
            }
            gc.fillRectangle(x, y, width, height);
        } else {
            org.eclipse.swt.graphics.Color oldForeground = gc.getForeground();
            org.eclipse.swt.graphics.Color lastColor = gradientColors[0];
            if (lastColor == null) {
                lastColor = oldBackground;
            }
            int pos = 0;
            int i = 0;
            while (i < gradientPercents.length) {
                gc.setForeground(lastColor);
                lastColor = gradientColors[i + 1];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                gc.setBackground(lastColor);
                if (vertical) {
                    int gradientHeight = gradientPercents[i] * height / 100 - pos;
                    gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                    pos += gradientHeight;
                } else {
                    int gradientWidth = gradientPercents[i] * width / 100 - pos;
                    gc.fillGradientRectangle(x + pos, y, gradientWidth, height, false);
                    pos += gradientWidth;
                }
                ++i;
            }
            if (vertical && pos < height) {
                gc.setBackground(oldBackground);
                gc.fillRectangle(x, y + pos, width, height - pos);
            }
            if (!vertical && pos < width) {
                gc.setBackground(oldBackground);
                gc.fillRectangle(x + pos, y, width - pos, height);
            }
            gc.setForeground(oldForeground);
        }
        gc.setBackground(oldBackground);
    }

    public static void drawRoundRectangle(GC gc, int x, int y, int width, int height, org.eclipse.swt.graphics.Color outerColor, org.eclipse.swt.graphics.Color borderColor, boolean roundTop, boolean roundBottom) {
        if (borderColor != null) {
            org.eclipse.swt.graphics.Color fore = gc.getForeground();
            gc.setForeground(borderColor);
            gc.drawRectangle(x, y, width, height - 1);
            gc.setForeground(fore);
        }
        if (roundTop) {
            GraphicUtils.drawRoundCorner(gc, x, y, outerColor, borderColor, null, true, true);
            GraphicUtils.drawRoundCorner(gc, x + width - 4, y, outerColor, borderColor, null, true, false);
        }
        if (roundBottom) {
            GraphicUtils.drawRoundCorner(gc, x, y + height - 5, outerColor, borderColor, null, false, true);
            GraphicUtils.drawRoundCorner(gc, x + width - 4, y + height - 5, outerColor, borderColor, null, false, false);
        }
    }

    public static void drawRoundRectangle(GC gc, int x, int y, int width, int height, org.eclipse.swt.graphics.Color outerColor, boolean roundTop, boolean roundBottom) {
        GraphicUtils.drawRoundRectangle(gc, x, y, width, height, outerColor, gc.getForeground(), roundTop, roundBottom);
    }

    public static void fillRoundRectangle(GC gc, int x, int y, int width, int height, org.eclipse.swt.graphics.Color outerColor) {
        GraphicUtils.fillRoundRectangle(gc, x, y, width, height, outerColor, true, true);
    }

    public static void fillRoundRectangle(GC gc, int x, int y, int width, int height, org.eclipse.swt.graphics.Color outerColor, boolean roundTop, boolean roundBottom) {
        gc.fillRectangle(x, y, width, height);
        if (roundTop) {
            GraphicUtils.drawRoundCorner(gc, x, y, outerColor, gc.getBackground(), gc.getBackground(), true, true);
            GraphicUtils.drawRoundCorner(gc, x + width - 5, y, outerColor, gc.getBackground(), gc.getBackground(), true, false);
        }
        if (roundBottom) {
            GraphicUtils.drawRoundCorner(gc, x, y + height - 5, outerColor, gc.getBackground(), gc.getBackground(), false, true);
            GraphicUtils.drawRoundCorner(gc, x + width - 5, y + height - 5, outerColor, gc.getBackground(), gc.getBackground(), false, false);
        }
    }

    public static int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = GraphicUtils.blend(c1.red, c2.red, ratio);
        int g = GraphicUtils.blend(c1.green, c2.green, ratio);
        int b = GraphicUtils.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    public static org.eclipse.swt.graphics.Color createNewBlendedColor(RGB rgb1, RGB rgb2, int ratio) {
        org.eclipse.swt.graphics.Color newColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), GraphicUtils.blend(rgb1, rgb2, ratio));
        return newColor;
    }

    public static org.eclipse.swt.graphics.Color createNewBlendedColor(org.eclipse.swt.graphics.Color c1, org.eclipse.swt.graphics.Color c2, int ratio) {
        org.eclipse.swt.graphics.Color newColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), GraphicUtils.blend(c1.getRGB(), c2.getRGB(), ratio));
        return newColor;
    }

    public static org.eclipse.swt.graphics.Color createNewReverseColor(org.eclipse.swt.graphics.Color c) {
        org.eclipse.swt.graphics.Color newColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), 255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
        return newColor;
    }

    public static RGB saturate(RGB rgb, float saturation) {
        float[] hsb = Color.RGBtoHSB(rgb.red, rgb.green, rgb.blue, null);
        hsb[1] = hsb[1] + saturation;
        if (hsb[1] > 1.0f) {
            hsb[1] = 1.0f;
        }
        if (hsb[1] < 0.0f) {
            hsb[1] = 0.0f;
        }
        hsb[0] = hsb[0] + saturation;
        if (hsb[0] > 1.0f) {
            hsb[0] = 1.0f;
        }
        if (hsb[0] < 0.0f) {
            hsb[0] = 0.0f;
        }
        Color awtColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    public static org.eclipse.swt.graphics.Color createNewSaturatedColor(org.eclipse.swt.graphics.Color c, float saturation) {
        RGB newRGB = GraphicUtils.saturate(c.getRGB(), saturation);
        return new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), newRGB);
    }
}

