/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.nebula.widgets.pgroup;

import com.silabs.nebula.widgets.pgroup.AbstractGroupStrategy;
import com.silabs.nebula.widgets.pgroup.AbstractToolItemRenderer;
import com.silabs.nebula.widgets.pgroup.PGroup;
import com.silabs.nebula.widgets.pgroup.PGroupToolItem;
import com.silabs.nebula.widgets.pgroup.internal.GraphicUtils;
import com.silabs.nebula.widgets.pgroup.internal.TextUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public class FormRectangleGroupStrategy
extends AbstractGroupStrategy {
    private Color initialBackColor;
    private Color initialBorderColor;
    private int titleTextMargin = 2;
    private int betweenSpacing = 6;
    private int margin = 0;
    private int vMargin = 2;
    private int hMargin = 6;
    private Color borderColor;
    private int titleHeight;
    private int textWidth;
    private int fontHeight;
    private Rectangle toolItemArea;

    @Override
    public void initialize(PGroup sg) {
        super.initialize(sg);
        RGB borderRGB = GraphicUtils.blend(this.getGroup().getDisplay().getSystemColor(35).getRGB(), this.getGroup().getDisplay().getSystemColor(25).getRGB(), 100);
        this.borderColor = this.initialBorderColor = new Color((Device)this.getGroup().getDisplay(), borderRGB);
        RGB backRGB = new RGB(220, 220, 220);
        this.initialBackColor = new Color((Device)this.getGroup().getDisplay(), backRGB);
    }

    @Override
    public void paint(GC gc) {
        Color back = this.getGroup().getBackground();
        if (back != null) {
            gc.fillRectangle(0, 0, this.getGroup().getSize().x, this.getGroup().getSize().y);
            Region reg = new Region();
            reg.add(0, 0, 5, 1);
            reg.add(0, 1, 3, 1);
            reg.add(0, 2, 2, 1);
            reg.add(0, 3, 1, 1);
            reg.add(0, 4, 1, 1);
            reg.add(this.getGroup().getSize().x - 5, 0, 5, 1);
            reg.add(this.getGroup().getSize().x - 3, 1, 3, 1);
            reg.add(this.getGroup().getSize().x - 2, 2, 2, 1);
            reg.add(this.getGroup().getSize().x - 1, 3, 1, 1);
            reg.add(this.getGroup().getSize().x - 1, 4, 1, 1);
            gc.setClipping(reg);
            this.getGroup().drawBackground(gc, 0, 0, this.getGroup().getSize().x, 5);
            gc.setClipping(null);
            reg.dispose();
        }
        Point imagePoint = new Point(0, 0);
        if (this.getGroup().getToggleRenderer() != null) {
            Point p = this.getGroup().getToggleRenderer().getSize();
            int toggleY = 0;
            toggleY = (this.titleHeight - p.y) / 2;
            int toggleX = 0;
            toggleX = (this.getGroup().getTogglePosition() & 0x4000) != 0 ? this.hMargin : this.getGroup().getSize().x - this.hMargin - p.x;
            this.getGroup().getToggleRenderer().setLocation(new Point(toggleX, toggleY));
        }
        back = gc.getBackground();
        Color fore = gc.getForeground();
        gc.setForeground(this.initialBackColor);
        gc.setBackground(this.getGroup().getParent().getBackground());
        Pattern p = new Pattern((Device)this.getGroup().getDisplay(), 0.0f, 0.0f, 0.0f, (float)this.titleHeight, this.initialBackColor, 90, this.initialBackColor, 255);
        gc.setBackgroundPattern(p);
        gc.fillRectangle(0, 0, this.getGroup().getSize().x, this.titleHeight);
        p.dispose();
        gc.setBackgroundPattern(null);
        gc.setForeground(this.getGroup().getParent().getBackground());
        gc.setBackground(back);
        gc.setForeground(fore);
        Image image = this.getGroup().getImage();
        if (image != null) {
            imagePoint.x = this.hMargin;
            if ((this.getGroup().getImagePosition() & 0x4000) != 0) {
                if (this.getGroup().getToggleRenderer() != null && (this.getGroup().getTogglePosition() & 0x4000) != 0) {
                    imagePoint.x += this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
                }
            } else {
                imagePoint.x = this.getGroup().getToggleRenderer() != null ? ((this.getGroup().getTogglePosition() & 0x4000) != 0 ? this.getGroup().getSize().x - (this.hMargin + image.getBounds().width) : this.getGroup().getSize().x - (this.hMargin + image.getBounds().width + this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing)) : this.getGroup().getSize().x - (this.hMargin + image.getBounds().width);
            }
            imagePoint.y = (this.titleHeight - image.getBounds().height) / 2;
            gc.drawImage(image, imagePoint.x, imagePoint.y);
        }
        Rectangle textBounds = this.getTextBounds();
        String shortened = TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width);
        if (this.getGroup().getToolItems().length > 0 && this.getGroup().getToolItemRenderer() != null) {
            PGroupToolItem[] items = this.getGroup().getToolItems();
            AbstractToolItemRenderer renderer = this.getGroup().getToolItemRenderer();
            Point size = new Point(0, 0);
            Point minSize = new Point(0, 0);
            int spacing = 3;
            int i = 0;
            while (i < items.length) {
                PGroupToolItem item = items[i];
                Point s0 = renderer.computeSize(gc, item, 1);
                Point s1 = renderer.computeSize(gc, item, 2);
                size.x += s0.x + spacing;
                minSize.x += s1.x + spacing;
                ++i;
            }
            boolean min = false;
            if (shortened.length() != this.getGroup().getText().length()) {
                textBounds.width -= minSize.x;
                min = true;
            } else if (!TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width - size.x).equals(this.getGroup().getText())) {
                textBounds.width -= minSize.x;
                min = true;
            } else {
                textBounds.width -= size.x;
            }
            shortened = TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width);
            int x = textBounds.x + textBounds.width;
            this.toolItemArea = min ? new Rectangle(x, 2, minSize.x, this.titleHeight - 4) : new Rectangle(x, 2, size.x, this.titleHeight - 4);
        }
        gc.drawText(TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width), textBounds.x, textBounds.y, true);
    }

    @Override
    public Rectangle getToolItemArea() {
        return this.toolItemArea;
    }

    @Override
    public boolean isToggleLocation(int x, int y) {
        if (super.isToggleLocation(x, y)) {
            return true;
        }
        return this.getGroup().getToggleRenderer() != null;
    }

    private Rectangle getTextBounds() {
        Point textPoint = new Point(0, 0);
        textPoint.x = this.hMargin;
        textPoint.y = (this.titleHeight - this.fontHeight) / 2;
        if (this.getGroup().getImage() != null && (this.getGroup().getImagePosition() & 0x4000) != 0) {
            textPoint.x += this.getGroup().getImage().getBounds().width + this.betweenSpacing;
        }
        if (this.getGroup().getToggleRenderer() != null && (this.getGroup().getTogglePosition() & 0x4000) != 0) {
            textPoint.x += this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
        }
        int textWidth = this.getGroup().getSize().x - this.hMargin * 2;
        if (this.getGroup().getImage() != null) {
            textWidth -= this.getGroup().getImage().getBounds().width + this.betweenSpacing;
        }
        if (this.getGroup().getToggleRenderer() != null) {
            textWidth -= this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
        }
        return new Rectangle(textPoint.x, textPoint.y, textWidth, this.fontHeight);
    }

    @Override
    public Rectangle getClientArea() {
        Rectangle area = this.getGroup().getBounds();
        area.x = this.margin;
        area.y = this.titleHeight;
        area.width -= 2 * this.margin;
        area.height -= this.titleHeight + this.margin;
        return area;
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle area = new Rectangle(x, y, width, height);
        area.x -= this.margin;
        area.y -= this.titleHeight;
        area.width += 2 * this.margin;
        area.height += this.titleHeight + this.margin;
        return area;
    }

    @Override
    public void dispose() {
        if (this.initialBackColor != null) {
            this.initialBackColor.dispose();
        }
        if (this.initialBorderColor != null) {
            this.initialBorderColor.dispose();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public void update() {
        GC gc = new GC((Drawable)this.getGroup());
        this.titleHeight = 0;
        if (this.getGroup().getImage() != null) {
            this.titleHeight = this.getGroup().getImage().getBounds().height + 2 * this.vMargin;
        }
        if (this.getGroup().getToggleRenderer() != null) {
            int toggleHeight = this.getGroup().getToggleRenderer().getSize().y;
            this.titleHeight = Math.max(toggleHeight + 2 * this.vMargin, this.titleHeight);
        }
        this.titleHeight = Math.max(gc.getFontMetrics().getHeight() + 2 * this.titleTextMargin + 2 * this.vMargin, this.titleHeight);
        this.textWidth = gc.stringExtent((String)this.getGroup().getText()).x;
        this.fontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
    }
}

